# 
# patch-level-lt.sh: compare two patch level names
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "compare two patch level names\\n"
		printf "usage: patch-level-lt [options] [--] A B\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf "Check if patch level name A is an earlier level than B.  Exit with\\n"
		printf "status 0 if it is, 1 otherwise.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

errname=

while test $# -ne 0 ; do

  case "$1" in 

    --)			shift
    			break
			;;
			
    -*)			printf "patch-level-lt: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 2 ; then
  printf "usage: patch-level-lt [options] [--] A B\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

A="$1"
B="$2"

################################################################
# Check the Id String
# 

if test "$A" = "$B" ; then
  exit 1
fi

lesser="`printf "%s\\n%s\\n" "$A" "$B" \
	 | sort -t- -k 1,1 -k 2,2n \
	 | head -1`"

if test "$lesser" = "$A" ; then
  exit 0
else
  exit 1
fi

# tag: Tom Lord Sat Jan  5 12:33:31 2002 (naming-conventions/patch-level-lt.sh)
#
