# 
# cached-index.sh: find or create a cached tree index
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "find or create a cached tree index\\n"
		printf "usage: cached-index [options] dir\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf "Look for a cached inventory (--source --all --tags) in DIR\\n"
		printf "(creating one if necessary) and return an absolute path name\\n"
		printf "of a file containing the index.\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

while test $# -ne 0 ; do

  case "$1" in 

    --)			shift
			break
			;;

    -*)			printf "cached-index: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 1 ; then
  printf "usage: cached-index [options] dir\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

dir="$1"
shift

################################################################
# Sanity Check and Process Defaults
# 

cd "$dir"
dir="`pwd`"

################################################################
# Look for Cached Copies
# 

cd "$dir"

if test -e "++cached-index" ; then
  printf "%s/++cached-index\\n" "$dir"
  exit 0
else
  rm -f ,,cached-index
  larch inventory --source --tags --all | sort -k 2 > ,,cached-index
  mv ,,cached-index ++cached-index
  printf "%s/++cached-index\\n" "$dir"
  exit 0
fi

# tag: Tom Lord Fri Dec 14 01:42:34 2001 (local-cache/cached-index.sh)
#
