// vs_menubar.cc

#include "vs_container.h"
#include "vs_menubar.h"
#include "vscreen.h"

#include "config/colors.h"

#include <sigc++/bind.h>

using namespace std;

keybindings *vs_menubar::bindings=NULL;

vs_menubar::vs_menubar(bool _always_visible)
  :vs_container(), active(false), always_visible(_always_visible), curloc(0), subwidget(NULL)
{
  do_layout.connect(slot(this, &vs_menubar::layout_me));

  focussed.connect(slot(this, &vs_menubar::got_focus));
  unfocussed.connect(slot(this, &vs_menubar::lost_focus));
}

vs_menubar::~vs_menubar()
{
}

void vs_menubar::got_focus()
{
  vscreen_widget *w=get_focus();
  if(w)
    w->focussed();
}

void vs_menubar::lost_focus()
{
  vscreen_widget *w=get_focus();
  if(w)
    w->unfocussed();
}

bool vs_menubar::focus_me()
{
  if(active)
    return true;
  else if(subwidget && subwidget->focus_me())
    return true;
  else
    return vscreen_widget::focus_me();
}

vscreen_widget *vs_menubar::get_focus()
{
  if(active)
    {
      if(!active_menus.empty())
	return active_menus.front();
      else
	return NULL;
    }
  else if(subwidget)
    return subwidget;
  else
    return NULL;
}

bool vs_menubar::get_cursorvisible()
{
  vscreen_widget *w=get_focus();
  return (w && w->get_cursorvisible()) || active;
}

point vs_menubar::get_cursorloc()
{
  vscreen_widget *w=get_focus();

  if(w)
    {
      point p=w->get_cursorloc();
      p.x+=w->get_startx();
      p.y+=w->get_starty();
      return p;
    }
  else if(active)
    return point(get_menustart(curloc), 0);
  else
    return point(0, 0);
}

int vs_menubar::get_menustart(int idx)
{
  int rval=0;
  for(int i=0; i<idx; i++)
    rval+=items[i].title.size();
  return rval;
}

void vs_menubar::append_item(string title, vs_menu *menu)
{
  items.push_back(item(' '+title+' ', menu));

  menu->shown_sig.connect(bind(slot(this, &vs_menubar::show_menu), menu));
  menu->hidden_sig.connect(bind(slot(this, &vs_menubar::hide_menu), menu));
  menu->menus_goaway.connect(slot(this, &vs_menubar::disappear));
  menu->set_owner(this);

  vscreen_update();
}

void vs_menubar::set_subwidget(vscreen_widget *w)
{
  if(subwidget)
    subwidget->set_owner(NULL);

  if(subwidget)
    subwidget->unfocussed();

  subwidget=w;

  if(subwidget)
    subwidget->set_owner(this);

  if(subwidget)
    subwidget->focussed();

  vscreen_queuelayout();
}

void vs_menubar::show_all()
{
  if(subwidget)
    subwidget->show_all();
}

size vs_menubar::size_request()
{
  int w=0;
  int h=1;

  for(itemlist::size_type i=0; i<items.size(); i++)
    w+=items[i].title.size();

  for(activemenulist::iterator i=active_menus.begin(), num=0;
      i!=active_menus.end();
      i++, num++)
    {
      int menux=0;
      // FIXME: be less horrendously inefficient
      for(itemlist::size_type j=0; j<items.size(); j++)
	{
	  if(items[j].menu==*i)
	    break;

	  menux+=items[j].title.size();
	}

      size req=(*i)->size_request();
      if(w<menux+req.w)
	w=menux+req.w;

      if(h<1+req.h)
	h=1+req.h;
    }

  if(subwidget)
    {
      size req=subwidget->size_request();

      if(w<req.w)
	w=req.w;
      if(h<req.h)
	h=req.h;
    }

  return size(w, h);
}

void vs_menubar::layout_me()
{
  for(activemenulist::iterator i=active_menus.begin();
      i!=active_menus.end();
      i++)
    {
      int menux=0;
      // FIXME: be less horrendously inefficient
      for(itemlist::size_type j=0; j<items.size(); j++)
	{
	  if(items[j].menu==*i)
	    break;

	  menux+=items[j].title.size();
	}

      size req=(*i)->size_request();
      if(getmaxx()<menux+req.w)
	req.w=getmaxx()-menux;

      if(getmaxy()<1+req.h)
	req.h=getmaxy()-1;

      (*i)->alloc_size(menux,
		       1,
		       req.w,
		       req.h);
    }

  if(subwidget)
    subwidget->alloc_size(0,
			  always_visible?1:0,
			  getmaxx(),
			  always_visible?getmaxy()-1:getmaxy());
}

void vs_menubar::show_menu(vs_menu *w)
{
  if(active)
    {
      vscreen_widget *old_focus=get_focus();

      for(activemenulist::iterator i=active_menus.begin();
	  i!=active_menus.end();
	  i++)
	assert(w!=*i);

      if(old_focus)
	old_focus->unfocussed();

      active_menus.push_front(w);

      w->focussed();

      vscreen_queuelayout();
      vscreen_update();
    }
}

void vs_menubar::hide_menu(vs_menu *w)
{
  if(active)
    {
      for(activemenulist::iterator i=active_menus.begin();
	  i!=active_menus.end();
	  i++)
	{
	  if(*i==w)
	    {
	      w->unfocussed();
	      active_menus.remove(w);

	      vscreen_widget *new_focus=get_focus();
	      if(new_focus)
		new_focus->focussed();

	      vscreen_queuelayout();
	      vscreen_update();
	      return;
	    }
	}

      abort();
    }
}

void vs_menubar::appear()
{
  if(!active)
    {
      active=true;
      if(subwidget)
	subwidget->unfocussed();

      // Added to eliminate the weird "titles are selected but contents aren't"
      // state that was normal with the previous settings:
      if(items.size()>0)
	items[curloc].menu->show();

      vscreen_update();
    }
}

void vs_menubar::disappear()
{
  if(active)
    {
      while(!active_menus.empty())
	active_menus.front()->hide();

      active=false;
      if(subwidget)
	subwidget->focussed();

      curloc=0;

      vscreen_update();
    }
}

bool vs_menubar::handle_char(chtype ch)
{
  if(bindings->key_matches(ch, "ToggleMenuActive"))
    {
      if(active)
	disappear();
      else
	appear();
    }
  else if(active)
    {
      if(bindings->key_matches(ch, "Cancel"))
	{
	  disappear();

	  //if(!active_menus.empty())
	  //  active_menus.front()->hide();
	  //else
	  //  disappear();

	  vscreen_update();
	}
      else if(!active_menus.empty())
	{
	  if(bindings->key_matches(ch, "Right"))
	    {
	      if(items.size()>0)
		{
		  while(!active_menus.empty())
		    active_menus.front()->hide();

		  active_menus.clear();

		  if(curloc<items.size()-1)
		    curloc++;
		  else
		    curloc=0;

		  items[curloc].menu->show();

		  vscreen_update();
		}
	    }
	  else if(bindings->key_matches(ch, "Left"))
	    {
	      if(items.size()>0)
		{
		  while(!active_menus.empty())
		    active_menus.front()->hide();

		  active_menus.clear();

		  if(curloc>0)
		    curloc--;
		  else
		    curloc=items.size()-1;

		  items[curloc].menu->show();
		  vscreen_update();
		}
	    }
	  else if(active_menus.front()->dispatch_char(ch))
	    return true;
	  else
	    return vscreen_widget::handle_char(ch);
	}
      else if(bindings->key_matches(ch, "Right"))
	{
	  if(items.size()>0)
	    {
	      if(curloc<items.size()-1)
		curloc++;
	      else
		curloc=0;

	      vscreen_update();
	    }
	}
      else if(bindings->key_matches(ch, "Left"))
	{
	  if(items.size()>0)
	    {
	      if(curloc>0)
		curloc--;
	      else
		curloc=items.size()-1;

	      vscreen_update();
	    }
	}
      else if(bindings->key_matches(ch, "Down") || bindings->key_matches(ch, "Confirm"))
	{
	  if(items.size()>0)
	    items[curloc].menu->show();
	}
      else
	return vscreen_widget::handle_char(ch);

      return true;
    }
  else if(subwidget && subwidget->dispatch_char(ch))
    return true;
  else
    return vscreen_widget::handle_char(ch);

  return true;
}

void vs_menubar::paint()
{
  if(subwidget)
    subwidget->display();

  if(active || always_visible)
    {
      if(active)
	for(activemenulist::reverse_iterator i=active_menus.rbegin();
	    i!=active_menus.rend();
	    i++)
	  (*i)->display();

      int loc=0, maxx=getmaxx();

      attrset(get_color("MenuBar"));
      move(0, 0);
      for(int i=0; i<maxx; i++)
	addch(' ');

      for(itemlist::size_type i=0; i<items.size() && loc<maxx; i++)
	{
	  if(active && i==curloc)
	    attrset(get_color("HighlightedMenuBar"));
	  else
	    attrset(get_color("MenuBar"));

	  mvaddnstr(0, loc, items[i].title.c_str(), maxx-loc);
	  loc+=items[i].title.size();
	}
    }
}

void vs_menubar::dispatch_mouse(short id, int x, int y, int z, mmask_t bmask)
{
  if(y==0)
    {
      if(bmask & (BUTTON1_CLICKED | BUTTON2_CLICKED |
		  BUTTON3_CLICKED | BUTTON4_CLICKED |
		  BUTTON1_RELEASED | BUTTON2_RELEASED |
		  BUTTON3_RELEASED | BUTTON4_RELEASED |
		  BUTTON1_PRESSED | BUTTON2_PRESSED |
		  BUTTON3_PRESSED | BUTTON4_PRESSED))
	{
	  if(!active)
	    appear();

	  int loc=0;
	  activemenulist::size_type i=0;

	  if(items.size()>0)
	    {
	      loc+=items[0].title.size();

	      while(i<items.size()-1 && loc<=x)
		{
		  loc+=items[i+1].title.size();

		  ++i;
		}
	    }

	  if(i<items.size())
	    {
	      while(!active_menus.empty())
		active_menus.front()->hide();

	      active_menus.clear();

	      curloc=i;

	      items[curloc].menu->show();

	      vscreen_update();
	    }
	}
    }
  else if(active)
    {
      for(activemenulist::iterator i=active_menus.begin();
	  i!=active_menus.end();
	  i++)
	if((*i)->enclose(y, x))
	  {
	    (*i)->dispatch_mouse(id,
				 x-(*i)->get_startx(), y-(*i)->get_starty(), z,
				 bmask);
	    return;
	  }
    }

  if(subwidget)
    subwidget->dispatch_mouse(id,
			      x-subwidget->get_startx(),
			      y-subwidget->get_starty(), z, bmask);
}

void vs_menubar::init_bindings()
{
  bindings=new keybindings(global_bindings);
}

void vs_menubar::set_always_visible(bool _always_visible)
{
  if(_always_visible!=always_visible)
    {
      always_visible=_always_visible;
      vscreen_update();
      vscreen_queuelayout();
    }
}
