// testvscreen.cc
//
//  I really need a test for the vscreen libraries that's separate from the
// main Aptitude program.  This is it.

#include "vscreen.h"
#include "vscreen_widget.h"
#include "vs_button.h"
#include "vs_center.h"
#include "vs_editline.h"
#include "vs_frame.h"
#include "vs_label.h"
#include "vs_multiplex.h"
#include "vs_minibuf_win.h"
#include "vs_menu.h"
#include "vs_menubar.h"
#include "vs_pager.h"
#include "vs_radiogroup.h"
#include "vs_scrollbar.h"
#include "vs_stacked.h"
#include "vs_subtree.h"
#include "vs_table.h"
#include "vs_togglebutton.h"
#include "vs_tree.h"
#include "vs_util.h"

#include <config/colors.h>

#include <string>

#include <sigc++/bind.h>

using namespace std;

// Er..having this be global is not so great?
vs_stacked *stacker=new vs_stacked(0,0);

class test_keyname:public vs_label
{
public:
  test_keyname():vs_label("")
  {
    set_bg(get_color("EditLine"));
  }

  size size_request()
  {
    return size(10, 0);
  }

  bool focus_me() {return true;}

  bool handle_char(chtype ch) {set_text(keyname(ch)); return true;}
};

class silly_block:public vscreen_widget
{
public:
  silly_block(int mybkgd)
  {
    set_bg(mybkgd);
  }

  size size_request()
  {
    return size(0,0);
  }

  void paint()
  {
  }
};

class silly_treeitem:public vs_treeitem
{
  string txt;
public:
  silly_treeitem(string _txt):txt(_txt) {}

  void paint(vs_tree *win, int y, bool hierarchical)
  {
    vs_treeitem::paint(win, y, hierarchical, txt);
  }

  const char *tag() const {return txt.c_str();}
  const char *label() const {return txt.c_str();}
};

class silly_subtree:public vs_subtree_generic
{
  string txt;
public:
  silly_subtree(bool expanded, string _txt)
    :vs_subtree_generic(expanded), txt(_txt) {}

  void paint(vs_tree *win, int y, bool hierarchical)
  {
    vs_subtree_generic::paint(win, y, hierarchical, txt);
  }

  const char *tag() const {return txt.c_str();}
  const char *label() const {return txt.c_str();}
};

void do_toggle_hierarchical(vs_tree *tree)
{
  tree->set_hierarchical(!tree->get_hierarchical());
}

vscreen_widget *make_test_treewidget()
{
  vs_tree *tree=new vs_tree();

  silly_subtree *root=new silly_subtree(true, "The Root Of It All");
  silly_subtree *tree1=new silly_subtree(false, "Money");
  tree1->add_child(new silly_treeitem("Gold"));
  tree1->add_child(new silly_treeitem("Copper"));
  tree1->add_child(new silly_treeitem("Silver"));
  tree1->add_child(new silly_treeitem("Paper"));
  root->add_child(tree1);

  silly_subtree *tree2=new silly_subtree(false, "Entropy");
  silly_subtree *tree3=new silly_subtree(true, "Mortality");
  tree3->add_child(new silly_treeitem("Death"));
  tree3->add_child(new silly_treeitem("Famine"));
  tree3->add_child(new silly_treeitem("Pestilence"));
  tree3->add_child(new silly_treeitem("War"));
  tree2->add_child(tree3);
  tree2->add_child(new silly_treeitem("Rot"));
  tree2->add_child(new silly_treeitem("Decay"));
  tree2->add_child(new silly_treeitem("Bad Things"));
  root->add_child(tree2);

  silly_subtree *tree4=new silly_subtree(false, "More stuff");
  for(int i=0; i<10; i++)
    {
      char buf[32];

      snprintf(buf, sizeof(buf), "Category %d", i);

      silly_subtree *sub=new silly_subtree(false, buf);
      for(int j=0; j<10; j++)
	{
	  snprintf(buf, sizeof(buf), "Item %d", j);
	  sub->add_child(new silly_treeitem(buf));
	}

      tree4->add_child(sub);
    }
  root->add_child(tree4);
  root->sort();

  tree->set_root(root, true);

  tree->connect_key("ToggleHier", &global_bindings,
		    bind(slot(do_toggle_hierarchical), tree));

  return tree;
}

void show_nasty_message()
{
  stacker->add_visible_widget(vs_dialog_ok("Your mother was a hamster, and your father smelt of elderberry!\n\n\tNow go away, or I shall taunt you a second time!", NULL), true);
}

void interrogate()
{
  stacker->add_visible_widget(vs_dialog_yesno("Do you like Debian?", NULL, SigC::slot(show_nasty_message)), true);
}

void dobeep()
{
  beep();
}

vs_menu_info test_file_menu[]=
{
  vs_menu_info(vs_menu_info::VS_MENU_ITEM, "^Interrogate", NULL,
   "NO-ONE EXPECTS THE SPANISH INQUISITION!", SigC::slot(&interrogate)),
  VS_MENU_SEPARATOR,
  vs_menu_info(vs_menu_info::VS_MENU_ITEM, "^Quit", "Quit",
   "Leave this wonderful program", SigC::slot(&vscreen_exitmain)),
  VS_MENU_END,
};

vs_menu_info test_test_menu[]=
{
  vs_menu_info(vs_menu_info::VS_MENU_ITEM, "Test ^Item 1", NULL, "Foo", SigC::slot(&dobeep)),
  vs_menu_info(vs_menu_info::VS_MENU_ITEM, "Test Item ^2", NULL, "Bar", SigC::slot(&dobeep)),
  VS_MENU_SEPARATOR,
  vs_menu_info(vs_menu_info::VS_MENU_ITEM, "Test Item ^3", NULL, "Baz", SigC::slot(&dobeep)),
  VS_MENU_END
};

vs_menu_info test_help_menu[]=
{
  vs_menu_info(vs_menu_info::VS_MENU_ITEM, "^About", NULL, "Useless dialog box",
	       VS_MENU_NOP),
  VS_MENU_SEPARATOR,
  vs_menu_info(vs_menu_info::VS_MENU_ITEM, "^Help...", "Help", "unimplemented",
	       VS_MENU_NOP),
  vs_menu_info(vs_menu_info::VS_MENU_ITEM, "^Don't help...", NULL, "unimplemented",
	       VS_MENU_NOP),
  VS_MENU_END
};

void radio_button_selected(int id, vs_label *l)
{
  char buf[128];

  snprintf(buf, 128, "You have selected button %i", id);
  l->set_text(buf);
}

vscreen_widget *button_mania()
{
  vs_table *rval=new vs_table;
  vs_label *label=new vs_label("ERROR");

  rval->add_widget(label, 5, 0, 1, 4, false);

  for(int i=0; i<4; i++)
    {
      vs_radiogroup *g=NULL;

      if(i==3)
	{
	  g=new vs_radiogroup;
	  g->item_selected.connect(bind(slot(&radio_button_selected), label));
	}
      for(int j=0; j<4; j++)
	{
	  char buf[256];
	  snprintf(buf, 256, "Button %i", i*4+j);

	  if(i!=3)
	    rval->add_widget(new vs_button(buf), i, j, 1, 1);
	  else
	    {
	      vs_togglebutton *b=new vs_radiobutton(buf);
	      rval->add_widget(b, i, j, 1, 1, true);
	      g->add_button(b, i*4+j);
	    }
	}
    }

  rval->add_widget_opts(new vs_checkbutton("Button 16"), 4, 0, 1, 2,
			vs_table::ALIGN_CENTER,
			vs_table::ALIGN_CENTER | vs_table::EXPAND);
  rval->add_widget_opts(new vs_button("Button 17"), 4, 2, 1, 2,
			vs_table::ALIGN_CENTER,
			vs_table::ALIGN_CENTER | vs_table::EXPAND);

  return rval;
}

static void do_load_file(string s, vs_editline *p)
{
  p->set_text("");
}

vscreen_widget *pager_test()
{
  vs_table *tbl=new vs_table;
  vs_editline *ln=new vs_editline("Enter a filename to load: ");
  const char *s="This space for rent.\n\nApply above.";
  vs_file_pager *pager=new vs_file_pager(s, strlen(s));
  vs_scrollbar *scrl=new vs_scrollbar(vs_scrollbar::VERTICAL,
				      pager->get_maxy(),
				      pager->get_cury());

  tbl->add_widget_opts(ln, 0, 0, 1, 2, vs_table::EXPAND | vs_table::SHRINK, vs_table::SHRINK);
  tbl->add_widget_opts(pager, 1, 0, 1, 1, vs_table::SHRINK, vs_table::EXPAND);
  tbl->add_widget_opts(scrl, 1, 1, 1, 1, vs_table::ALIGN_LEFT, vs_table::EXPAND);

  ln->entered.connect(bind(SigC::slot(&do_load_file), ln));
  ln->entered.connect(slot(pager, &vs_file_pager::load_file));
  pager->location_changed.connect(slot(scrl, &vs_scrollbar::set_slider));

  return tbl;
}

void update_menu_status(vs_menu_item *item, vs_label *label)
{
  if(item)
    {
      label->show();
      label->set_text(item->get_description());
    }
  else
    label->hide();
}

void do_editline_history(std::string s, vs_editline *l)
{
  l->add_to_history(s);
  l->reset_history();
  l->set_text("");
}

int main(int argc, char *argv[])
{
  vscreen_init();

  global_bindings.set("CycleScreen", KEY_F(6));
  global_bindings.set("ToggleCellVisible", KEY_F(5));
  global_bindings.set("ToggleHier", 'h');

  vs_menubar *menubar=new vs_menubar();

  menubar->connect_key_post("Quit", &global_bindings, SigC::slot(&vscreen_exitmain));

  vs_label *menu_display=new vs_label("", get_color("ScreenStatusColor"));

  vs_menu *menu=new vs_menu(0, 0, 15, test_file_menu);
  menubar->append_item("File", menu);
  menu->item_highlighted.connect(bind(slot(&update_menu_status),
				      menu_display));

  menu=new vs_menu(0, 0, 15, test_test_menu);
  menubar->append_item("Test", menu);
  menu->item_highlighted.connect(bind(slot(&update_menu_status),
				      menu_display));

  menu=new vs_menu(0, 0, 15, test_help_menu);
  menubar->append_item("Help", menu);
  menu->item_highlighted.connect(bind(slot(&update_menu_status),
				      menu_display));

  vs_minibuf_win *toplevel=new vs_minibuf_win();

  toplevel->add_widget(menu_display);

  menubar->set_subwidget(toplevel);

  vs_multiplex *switcher=new vs_multiplex();
  switcher->connect_key("CycleScreen",
			&global_bindings,
			slot(switcher, &vs_multiplex::cycle_forward));

  switcher->add_visible_widget(pager_test(), true);
  switcher->add_visible_widget(button_mania(), true);

  switcher->add_visible_widget(new vs_center(new vs_frame(new vs_label("\tThis is another screen.\nNotice that both tabs and newlines work properly."))), true);
  switcher->add_visible_widget(new vs_label("This is one screen."), true);
  switcher->add_visible_widget(vs_dialog_ok("Press any key to hide this widget"), true);
  switcher->add_visible_widget(make_test_treewidget(), true);

  vs_table *ttable=new vs_table;
  ttable->add_widget(new vs_frame(new vs_label("Press a key:")));
  ttable->add_widget(new vs_frame(new test_keyname));
  ttable->show_all();
  switcher->add_widget(ttable);

  vs_table *table=new vs_table;
  vscreen_widget *w=new vs_frame(new vs_center(new vs_label("Pane 1")));
  table->add_widget(w, 0, 0, 2, 1, false);
  w=new vs_frame(new vs_center(new vs_label("Pane 2")));
  table->add_widget(w, 0, 1, 1, 1, vs_table::EXPAND, 0);

  vs_editline::history_list h;
  vs_editline *l=new vs_editline(20, "Input: ", "Pane 3", &h);
  l->entered.connect(bind(SigC::slot(&do_editline_history),
			  l));

  w=new vs_frame(new vs_center(l));
  table->add_widget(w, 1, 1);
  w=new vs_frame(new vs_center(new vs_label("Pane 4 - a pane with a very long label in it\nwhich should crowd out the other table cells")));
  table->connect_key("ToggleCellVisible",
		     &global_bindings,
		     slot(w, &vscreen_widget::toggle_visible));
  table->add_widget(w, 0, 2, 2);
  table->show_all();
  switcher->add_widget(table);

  stacker->add_visible_widget(switcher, true);

  stacker->add_visible_widget(vs_dialog_ok("Vscreen test program - press any key to begin"), true);

  toplevel->set_main_widget(stacker);
  stacker->show();
  toplevel->set_header("testvscreen");
  toplevel->set_header("This program tests the vscreen text UI library");

  vscreen_settoplevel(menubar);

  vscreen_mainloop();

  rootwin.bkgdset(' ');
  rootwin.clear();
  rootwin.refresh();
  endwin();

  return 0;
}
