// ui.h    -*-c++-*-
//
//  Copyright 2000,2001 Daniel Burrows
//
//  Global UI definitions and routines.  A lot of things here just provide a
// single point for common actions so those actions can be customized later.
// (eg, the progress-bar can appear in various forms)

#ifndef UI_H
#define UI_H

#include <apt-pkg/pkgcache.h>

#include <sigc++/basic_signal.h>

#include <string>

#include <vscreen/slotarg.h>
#include <vscreen/vs_editline.h>
// Bleah..this needs to be included so histories work

class vscreen_widget;
class vs_progress;
class download_manager;
class pkg_hier;

/******************************************************************************
 * Global signals:
 *****************************************************************************/

// File menu
extern SigC::Signal0<void> file_quit;

/*****************************************************************************/

void ui_init();
void ui_main();

// Displays a "popup" widget.  If the second argument is false, show_all
// will not be called on the widget.
void popup_widget(vscreen_widget *w, bool do_show_all=true);

// Displays a widget on the "main" program level, inserting the given string
// into the menu listing available "main" screens to reference it.
//
// The "insert" form adds the new widget directly after the currently visible
// widget.
void add_main_widget(vscreen_widget *w, const std::string &menuref,
		     const std::string &menudesc);
void insert_main_widget(vscreen_widget *w, const std::string &menuref,
			const std::string &menudesc);

// Generates a progress bar.
vs_progress *gen_progress_bar();

// Similarly for download progress displays.
//
// force_noninvasive tells whether to use a 'non-invasive' display (ie, one
// that doesn't take over the screen..for  instance, the "status-line"-style
// download bar)
//
// abortslot, if present, is a slot which will abort the operation if invoked.
// (eg, so you can download packages but not install them)
download_manager *gen_download_progress(bool force_noninvasive=false,
					Slot0Arg abortslot=NULL);

// Asks the user for simple input (the question will appear in a "minibuffer"
// or in a dialog according to preferences)

void prompt_string(const std::string &prompt,
		   const std::string &text,
		   SlotArg<SigC::Slot1<void, string> > slot,
		   SlotArg<SigC::Slot0<void> > cancel_slot,
		   SlotArg<SigC::Slot1<void, string> > changed_slot,
		   vs_editline::history_list *history);

void prompt_yesno(const std::string &prompt,
		  bool deflt,
		  Slot0Arg yesslot,
		  Slot0Arg noslot);

void show_message(const std::string &msg,
		  Slot0Arg okslot,
		  int attr);

void show_message(const std::string &msg,
		  Slot0Arg okslot=NULL);

// Can be used to manually pop up an error dialog, if necessary.
void check_apt_errors();

void do_new_package_view();
// Displays a new package-view.

void do_package_run_or_show_preview();
// Shows a preview if previews are enabled (and why would you disable them?),
// otherwise does the same thing as install_or_remove_packages.

void install_or_remove_packages();
// Installs or removes packages.  (the thing that happens after you press
// "g" twice)

void do_update_lists();
// Updates the package lists.

void do_forget_new();
// Forgets which packages are "new".

// These generate particular screens of the UI:

// Info screen
vscreen_widget *make_info_screen(const pkgCache::PkgIterator &pkg,
				 const pkgCache::VerIterator &ver);
// Dependency screen
vscreen_widget *make_dep_screen(const pkgCache::PkgIterator &pkg,
				const pkgCache::VerIterator &ver,
				bool reverse=false);
// List of versions
vscreen_widget *make_ver_screen(const pkgCache::PkgIterator &pkg);

// Various defaults:
extern const char *default_pkgstatusdisplay;
extern const char *default_pkgheaderdisplay;
extern const char *default_grpstr;

#endif
