// pkg_node.cc
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Implementations of stuff in pkg_node.h

#include "vscreen/config/keybindings.h"

#include "pkg_node.h"

#include <generic/undo.h>
#include <generic/apt.h>
#include <generic/config_signal.h>

#include <vscreen/vs_tree.h>

keybindings *pkg_tree_node::bindings=NULL;

void apt_undo_group::undo()
{
  (*apt_cache_file)->begin_action_group();
  undo_group::undo();
  (*apt_cache_file)->end_action_group(NULL);
}

void pkg_tree_node::init_bindings()
{
  bindings=new keybindings(&global_bindings);
}

// FIXME: add a do_action() command that takes a function pointer and does all
// the extra junk below.
bool pkg_tree_node::dispatch_char(chtype ch, vs_tree *owner)
{
  if(bindings->key_matches(ch, "Install"))
    {
      undo_group *grp=new apt_undo_group;

      select(grp);

      if(!grp->empty())
	apt_undos->add_item(grp);
      else
	delete grp;

      if(aptcfg->FindB(PACKAGE "::UI::Advance-On-Action", false))
	owner->level_line_down();

      return true;
    }
  else if(global_bindings.key_matches(ch, "Remove"))
    {
      undo_group *grp=new apt_undo_group;

      remove(grp);

      if(!grp->empty())
	apt_undos->add_item(grp);
      else
	delete grp;

      if(aptcfg->FindB(PACKAGE "::UI::Advance-On-Action", false))
	owner->level_line_down();

      return true;
    }
  else if(global_bindings.key_matches(ch, "Hold"))
    {
      undo_group *grp=new apt_undo_group;

      hold(grp);

      if(!grp->empty())
	apt_undos->add_item(grp);
      else
	delete grp;

      if(aptcfg->FindB(PACKAGE "::UI::Advance-On-Action", false))
	owner->level_line_down();

      return true;
    }
  else if(global_bindings.key_matches(ch, "Purge"))
    {
      undo_group *grp=new apt_undo_group;

      purge(grp);

      if(!grp->empty())
	apt_undos->add_item(grp);
      else
	delete grp;

      if(aptcfg->FindB(PACKAGE "::UI::Advance-On-Action", false))
	owner->level_line_down();

      return true;
    }
  else if(global_bindings.key_matches(ch, "Reinstall"))
    {
      undo_group *grp=new apt_undo_group;

      reinstall(grp);

      if(!grp->empty())
	apt_undos->add_item(grp);
      else
	delete grp;

      if(aptcfg->FindB(PACKAGE "::UI::Advance-On-Action", false))
	owner->level_line_down();

      return true;
    }
  else if(global_bindings.key_matches(ch, "SetAuto"))
    {
      undo_group *grp=new apt_undo_group;

      set_auto(true, grp);

      if(!grp->empty())
	apt_undos->add_item(grp);
      else
	delete grp;

      if(aptcfg->FindB(PACKAGE "::UI::Advance-On-Action", false))
	owner->level_line_down();

      return true;
    }
  else if(global_bindings.key_matches(ch, "ClearAuto"))
    {
      undo_group *grp=new apt_undo_group;

      set_auto(false, grp);

      if(!grp->empty())
	apt_undos->add_item(grp);
      else
	delete grp;

      if(aptcfg->FindB(PACKAGE "::UI::Advance-On-Action", false))
	owner->level_line_down();

      return true;
    }
  else return false;
}
