// pkg_description_treeitem.cc
//
//  Copyright 1999,2000,2001 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Implementations for the pkg_description types.

#include "aptitude.h"

#include "pkg_description_treeitem.h"

#include "generic/apt.h"

void pkg_description::init(const pkgCache::VerIterator &ver, string _title)
{
  title=_title;

  string long_desc=apt_package_records->Lookup(ver.FileList()).LongDesc();
  std::string::size_type start=0, nextnl=long_desc.find('\n',start);

  if(nextnl!=string::npos)
    {
      children.push_back(new pkg_description_item(string(ver.ParentPkg().Name())+" - "+string(long_desc,start,nextnl-start)));
      start=nextnl+1;
      nextnl=long_desc.find('\n', start);
    }

  for(nextnl=long_desc.find('\n', start); nextnl!=string::npos; start=nextnl+1,nextnl=long_desc.find('\n', start))
    {
      string thisline(long_desc, start, nextnl-start);

      if(thisline!=" .")
	children.push_back(new pkg_description_item(string(thisline,1)));
      else
	children.push_back(new pkg_description_item(string("")));
    }

  // Ewww.   I have to do one extra loop iteration manually :(
  string thisline(long_desc, start, nextnl-start);

  if(thisline!=" .")
    children.push_back(new pkg_description_item(string(thisline,1)));
  else
    children.push_back(new pkg_description_item(string("")));
}

void pkg_description::paint(vs_tree *win, int y, bool hierarchical)
{
  vs_treeitem::paint(win, y, hierarchical, string(_(title.c_str())));
}

void pkg_description_item::paint(vs_tree *win, int y, bool hierarchical)
{
  vs_treeitem::paint(win, y, hierarchical, description);
}

vs_treeitem *pkg_description_screen::setup_new_root(const pkgCache::PkgIterator &pkg,
						    const pkgCache::VerIterator &ver)
{
  assert(!ver.end());

  char buf[512];
  snprintf(buf, 512, _("Description of %s"), ver.ParentPkg().Name());

  return new pkg_description(ver, buf);
}

pkg_description_screen::pkg_description_screen(const pkgCache::VerIterator &ver)
  :apt_info_tree(ver.ParentPkg().Name(), ver.VerStr())
{
  set_root(setup_new_root(ver.ParentPkg(), ver), false);
}
