// aptitudepolicy.cc
//
//  Copyright 2001 Daniel Burrows
//
//  A policy class that allows Recommends and Suggests to be treated as
// "always important", "important for new installs", or "never important".
//
//  Defaults are "new installs" for recommends and "never" for suggests..
// I suspect that whatever I do will upset someone, and these seem like
// sa[fn]e choices.

#include "aptitudepolicy.h"
#include "../aptitude.h"

#ifdef HAVE_CONFIG_H
#include "../../config.h"
#endif

#include "apt.h"
#include "config_signal.h"

#include <apt-pkg/pkgcache.h>
#include <apt-pkg/error.h>

#ifndef HAVE_LIBAPT_PKG3
#include "aptcache.h"
#endif

#ifdef HAVE_LIBAPT_PKG3
bool aptitudePolicy::IsImportantDep(pkgCache::DepIterator dep)
{
  if(pkgPolicy::IsImportantDep(dep))
    return true;
#else
  bool aptitudeDepCache::IsImportantDep(pkgCache::DepIterator dep)
{
  if(pkgDepCache::IsImportantDep(dep))
    return true;
#endif

  if(dep->Type==pkgCache::Dep::Recommends)
    return aptcfg->FindB(PACKAGE "::Recommends-Important", true);
  else if(dep->Type==pkgCache::Dep::Suggests)
    return aptcfg->FindB(PACKAGE "::Suggests-Important", false);
  else
    return false;
}
