// cmdline.h
//
//  Copyright 2002 Daniel Burrows
//
//  Support for actions from the command-line.

#ifndef CMDLINE_H
#define CMDLINE_H

#include <string>

class download_manager;

// Used by the download code; generates a download_progress thingy that will
// be hooked up to a text status-displayer.
download_manager *gen_cmdline_download_progress();

int cmdline_update(int argc, char *argv[]);
int cmdline_clean(int argc, char *argv[], bool simulate);
int cmdline_autoclean(int argc, char *argv[], bool simulate);
int cmdline_forget_new(int argc, char *argv[], bool simulate);
int cmdline_search(int argc, char *argv[],
		   std::string display_format, std::string width);
int cmdline_pkgaction(int argc, char *argv[], bool simulate,
		      bool assume_yes, bool download_only, bool fix_broken,
		      bool showvers, bool showdeps, bool always_prompt,
		      int verbose);
int cmdline_upgrade(int argc, char *argv[], bool simulate,
		    bool assume_yes, bool fix_broken,
		    bool showvers, bool showdeps, bool always_prompt,
		    int verbose);
int cmdline_download(int argc, char *argv[]);
int cmdline_moo(int argc, char *argv[], int verbose);

#endif
