//
// anyRemote
// a bluetooth remote for your PC.
//
// Copyright (C) 2006,2007,2008,2009,2010 Mikhail Fedotov <anyremote@mail.ru>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
//

/*
 * AT+CKPD commands handling
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "parse.h"
#include "utils.h"
#include "btio.h"
#include "conf.h"
#include "dispatcher.h"

#define PAUSE_TIME 1

extern char tmp[MAXMAXLEN];

int useQuestionInCLCC = 0;

void sendSyncCommand(char *bytes, char *answer, int size, char *expect) 
{
        DEBUG2("sendSyncCommand >%s<\n", bytes);
	
	// initial timeout was 5
        bt_put_command (bytes, answer, size, 40, expect); 
}

int sendCMER(int onOff)
{   
	char answer[100];
        char cmd[64];
	
	char * cmer = getAT_CMER(onOff);
	if (cmer == NULL) return EXIT_NOK;
	
        strcpy(cmd,cmer);
	free(cmer);
	
        strcat(cmd,"\r");
        //sendSyncCommand(cmd, answer, sizeof(answer), NULL);
	bt_put_command (cmd, answer, sizeof(answer), 10, NULL);
	
        if(!IS_OK(answer)) {
        	DEBUG2("ERROR: AT_CMER SET >%s< -> %s\n", cmd, answer);
                return EXIT_NOK;
        }
	return EXIT_OK;
}

// Send AT+CKPD command
static int sendCKPD(char *key)
{   
	char answer[1024];
        char ckpd[MAXCKPDLEN];

        if (key == NULL || key[0] == '\0') {
        	logger("DBG","Empty symbol in sendCKPD()");
                return EXIT_NOK;
        }
        DEBUG2("sendCKPD >%s<", key);

        sprintf(ckpd,"%s\"%s\"\r", DEF_AT_CKPD, key);

        int model = getModel();

        if (model == MODEL_SE || model == MODEL_SIEMENS) {  // SE-K700, Siemens-S55 
		// If we send AT+CKPD=X
                // SE phone will replay
                // OK
                // +CKEV: X,1
                // +CKEV: X,0
                // And we need to filter out that CKEVs
                char expect[16];
                strcpy(expect, DEF_CKEV);
                strcat(expect, " ");
		if (model == MODEL_SIEMENS) {
			strcat(expect, "\"");
		}
                strcat(expect, key);
		if (model == MODEL_SIEMENS) {
			strcat(expect, "\"");
		}
                strcat(expect, ",0");  // Wait button up event

                sendSyncCommand(ckpd, answer, sizeof(answer), expect);
                //DEBUG2("Expect >%s<", expect);
                //DEBUG2("Got all >%s<", answer);
 
                // Filter out button up
                char *ptr = strstr(answer, expect);
                if(ptr == NULL) {
                	logger("DBG","cant find button up event");
                } else {
                	int z;
                	int l = strlen(expect);
                	for (z=0; z<l; z++) {
                		*ptr = '\r';
                        	ptr++;
                	}
		}
		
                // Filter out button down
                strcpy(expect, DEF_CKEV);
                strcat(expect, " ");
		if (model == MODEL_SIEMENS) {
			strcat(expect, "\"");
		}
                strcat(expect, key);
		if (model == MODEL_SIEMENS) {
			strcat(expect, "\"");
		}
                strcat(expect, ",1");
                ptr = strstr(answer, expect);
                if(ptr == NULL) {
                	logger("DBG","cant find button down event");
                } else {
			int z;
                	int l = strlen(expect);
                	for (z=0; z<l; z++) {
                		*ptr = '\r';
                        	ptr++;
                	}
		}
                DEBUG2("Filtered >%s<", answer);

        } else {
        	sendSyncCommand(ckpd, answer, sizeof(answer), NULL);
        }
	
	parseCommand(answer);

        return EXIT_OK;
}

//
// Should be used in AT mode only
// 
int sendSeq(const char *seq) 
{
	if (getUseScreen() == 0 || seq == NULL) return EXIT_OK;

        DEBUG2("sendSeq() >%s<", seq);

        char* copy = strdup(seq);

        char *bufPtr = NULL;
        char *ckpd = strtok_r(copy," ",&bufPtr);

        while (ckpd != NULL) {
        	//DEBUG2("NEXT sendSeq()->sendCKPD()>%s<", ckpd);
        
                if (strcmp(ckpd, PAUSE_STR)==0) {
                        sleep(PAUSE_TIME);	// Just wait a bit
                } else {
                        sendCKPD(ckpd);
                }
                ckpd = strtok_r(NULL," ",&bufPtr);
        }
        free(copy);

        return EXIT_OK;
}

char *parse_CLCC(char *clcc)
{
	// There are could be more than one call at time ... but here we will get then one-by-one
	// +CLCC: 1,,4,0,0,"<phone number here>",129,
	char *start ,*ptr;
	int commaCount = 0;

	ptr = clcc;
	while(ptr && commaCount < 5) {
		if (*ptr == ',') {
			 commaCount++;
		}
		ptr++;
	}

	if (ptr == NULL) { // Call was finished
		return "FINISHED";
	}
	if (ptr && *ptr == '"') {
		ptr++;
	}    
	start = ptr;
	while(ptr && *ptr != '"' &&  *ptr != ',') {
		ptr++;
	}
	if (ptr) {
		*ptr = '\0';
	}

	if(start) {
		DEBUG2("parse_CLCC >%s<", start);
	} else {
		DEBUG2("parse_CLCC >NULL callerID<");
		return "NO CALLER ID";
	}

	return start;
}

int getClip(char* CallerID)
{
	char clcc[MTEXTLEN];
        char answer[1024];
        char *ptr;
        int   tryAnyway = 0;

        answer[0] = '\0';

        logger("DBG", "getClip()");


        // Some phones uses AT+CLCC?, some just AT+CLCC (Sagem, Siemens-S55, SE-K750)

        if (useQuestionInCLCC == 0) {
        	//logger("DBG", "getClip() send AT+CLCC");

                strcpy(clcc,DEF_AT_CLCC);
                strcat(clcc,"\r");

                sendSyncCommand(clcc, answer, sizeof(answer), NULL);

                if ((ptr = strstr(answer,DEF_CLCC)) != NULL) {
                	strcpy(CallerID, parse_CLCC(ptr));
                        return EXIT_EXACT;
                } else if (strstr(answer,"OK") != NULL) {
                	return EXIT_OK;
                } else if (strstr(answer,"ERR") != NULL) {
                	logger("WARNING", "Got ERROR on AT+CLCC. Will try AT+CLCC?");
                        useQuestionInCLCC = 1;      // Ask phone again; but will never ask AT+CLCC more
                } else {
                 	tryAnyway = 1;              // Ask phone again; to be sure
                }
        }

        if (useQuestionInCLCC == 1 || tryAnyway == 1) {
        	
                tryAnyway = 0;

                //logger("DBG", "getClip() send AT+CLCC?");

                strcpy(clcc,DEF_AT_CLCC);
                strcat(clcc,"?");
                strcat(clcc,"\r");

                sendSyncCommand(clcc, answer, sizeof(answer), NULL);

                if ((ptr = strstr(answer,DEF_CLCC)) != NULL) {
                	strcpy(CallerID, parse_CLCC(ptr));
                        return EXIT_EXACT;
                } else if (strstr(answer,"OK") != NULL) {
                	return EXIT_OK;
                } else if (strstr(answer,"ERR") != NULL) {
                	logger("ERR", "Got ERROR on AT+CLCC?");
                        return EXIT_NOK;
                }
        }

        DEBUG2("sendClip() unappropriate answer: >%s<", answer);

        return EXIT_NOK;
}
