//
//  print_dialog.c  --  created a print dialog box
//  -- created 5/23/00  updated 5/23/00
////////////////////////////////////////////

#include "print_dialog.h"

GtkWidget*
create_print_dialog (void)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *textbox;
  GtkWidget *label;
  GtkWidget *command_text;
  GtkWidget *action_area;
  GtkWidget *buttonbox;
  GtkWidget *print_button;
  GtkWidget *cancel_button;


  // BUILD DIALOG
  dialog = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (dialog), "dialog", dialog);
  gtk_window_set_title (GTK_WINDOW (dialog), "Print Message");
  gtk_window_set_policy (GTK_WINDOW (dialog), TRUE, TRUE, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (dialog), 10);

  box = GTK_DIALOG (dialog)->vbox;
  gtk_object_set_data (GTK_OBJECT (dialog), "box", box);
  gtk_widget_show (box);
  gtk_container_set_border_width (GTK_CONTAINER (box), 10);

  // BUILD TEXT BOX
  textbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (textbox);
  gtk_object_set_data_full (GTK_OBJECT (dialog), "textbox", textbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (textbox);
  gtk_box_pack_start (GTK_BOX (box), textbox, FALSE, FALSE, 0);


  // LABEL
  label = gtk_label_new ("Print command: ");
  gtk_widget_ref (label);
  gtk_object_set_data_full (GTK_OBJECT (dialog), "label", label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (textbox), label, FALSE, FALSE, 0);

  // TEXT AREA
  command_text = gtk_entry_new ();
  gtk_widget_ref (command_text);
  gtk_object_set_data_full (GTK_OBJECT (dialog), "command_text", command_text,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (command_text);
  gtk_box_pack_start (GTK_BOX (textbox), command_text, FALSE, FALSE, 0);
  gtk_entry_set_text (GTK_ENTRY (command_text), "lpr %s");


  // ACTION AREA
  action_area = GTK_DIALOG (dialog)->action_area;
  gtk_object_set_data (GTK_OBJECT (dialog), "action_area",
   		       action_area);
  gtk_widget_show (action_area);
  gtk_container_set_border_width (GTK_CONTAINER (action_area), 10);


  // BUILD BUTTON BOX
  buttonbox = gtk_hbutton_box_new ();
  gtk_widget_ref (buttonbox);
  gtk_object_set_data_full (GTK_OBJECT (dialog), "buttonbox", buttonbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (buttonbox);
  gtk_box_pack_start (GTK_BOX (action_area), buttonbox, TRUE, TRUE, 0);


  // CANCEL BUTTON
  cancel_button = gtk_button_new_with_label ("Cancel");
  gtk_widget_ref (cancel_button);
  gtk_object_set_data_full (GTK_OBJECT (dialog), "cancel_button",
			    cancel_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cancel_button);
  gtk_container_add (GTK_CONTAINER (buttonbox), cancel_button);
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);


  // PRINT BUTTON
  print_button = gtk_button_new_with_label ("Print");
  gtk_widget_ref (print_button);
  gtk_object_set_data_full (GTK_OBJECT (dialog), "print_button", print_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (print_button);
  gtk_container_add (GTK_CONTAINER (buttonbox), print_button);
  GTK_WIDGET_SET_FLAGS (print_button, GTK_CAN_DEFAULT);


  // SET UP CALLBACKS
  gtk_signal_connect (GTK_OBJECT (print_button), "clicked",
                      GTK_SIGNAL_FUNC (on_printButton_clicked),
                      GTK_OBJECT (command_text));
  gtk_signal_connect_object( GTK_OBJECT (print_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (dialog) );

  // The close button should destroy this window
  gtk_signal_connect_object( GTK_OBJECT (cancel_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (dialog) );


  gtk_widget_grab_focus (print_button);
  gtk_widget_grab_default (print_button);

  return dialog;
}

