//
//  new_message_window.c  --  The compose window for new messages
//  --  created 5/23/00  updated 5/23/00
////////////////////////////////////////////////

#include "new_message_window.h"

GtkWidget*
create_new_message_window (const string& to, const string& subject,
			   const string& cc, const string& body)
{
  GtkWidget *window;
  GtkWidget *vbox1;
  GtkWidget *toolbar;
  GtkWidget *send_button;
  GtkWidget *attach_button;
  GtkWidget *close_button;
  GtkWidget *to_box;
  GtkWidget *to_label;
  GtkWidget *to_text;
  GtkWidget *subject_box;
  GtkWidget *subject_label;
  GtkWidget *subject_text;
  GtkWidget *cc_box;
  GtkWidget *cc_label;
  GtkWidget *cc_text;
  GtkWidget *scrolledwindow1;
  GtkWidget *compose_text;

  GtkAccelGroup *new_accel_group;


  // BUILD WINDOW
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize (window, 500, 400);
  gtk_object_set_data (GTK_OBJECT (window), "window",
		       window);
  gtk_container_set_border_width (GTK_CONTAINER (window), 2);
  gtk_window_set_title (GTK_WINDOW (window), _("New Message"));
  gtk_window_set_default_size (GTK_WINDOW (window), 300, 250);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (window), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (window), vbox1);


  // BUILD TOOLBAR
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL,
			     GTK_TOOLBAR_BOTH);
  gtk_widget_ref (toolbar);
  gtk_object_set_data_full (GTK_OBJECT (window),
			    "toolbar", toolbar,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (toolbar);
  gtk_box_pack_start (GTK_BOX (vbox1), toolbar, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (toolbar), 2);
  gtk_toolbar_set_space_size (GTK_TOOLBAR (toolbar), 0);
  gtk_toolbar_set_button_relief(GTK_TOOLBAR(toolbar), GTK_RELIEF_NONE);


  // SEND BUTTON
  send_button = gtk_toolbar_append_item(GTK_TOOLBAR (toolbar),
					_("Send"),
					_("Send this message"), NULL,
					create_pixmap(window, "send.xpm"),
					NULL, NULL);
  gtk_widget_ref (send_button);
  gtk_object_set_data_full (GTK_OBJECT (window), "send_button",
			    send_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (send_button);
  gtk_widget_set_usize (send_button, 50, -2);


  // ATTACH BUTTON
  attach_button = gtk_toolbar_append_item(GTK_TOOLBAR (toolbar),
					  _("Attach"),
					  _("Add an attachment to this message"),
					  NULL,
					  create_pixmap(window, "attach.xpm"),
					  NULL, NULL);
  gtk_widget_ref (attach_button);
  gtk_object_set_data_full (GTK_OBJECT (window), "attach_button",
			    attach_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (attach_button);
  gtk_widget_set_usize (attach_button, 50, -2);


  // CLOSE BUTTON
  close_button = gtk_toolbar_append_item(GTK_TOOLBAR (toolbar),
					 _("Close"),
					 _("Abort this message"), NULL,
					 create_pixmap(window, "close.xpm"),
					 NULL, NULL);
  gtk_widget_ref (close_button);
  gtk_object_set_data_full (GTK_OBJECT (window), "close_button",
			    close_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (close_button);
  gtk_widget_set_usize (close_button, 50, -2);


  // BUILD HEADER INPUT AREA

  // TO FIELD
  to_box = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (to_box);
  gtk_object_set_data_full (GTK_OBJECT (window), "to_box", to_box,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (to_box);
  gtk_box_pack_start (GTK_BOX (vbox1), to_box, FALSE, TRUE, 0);
  gtk_widget_set_usize (to_box, 2, 20);
  gtk_container_set_border_width (GTK_CONTAINER (to_box), 2);

  to_label = gtk_label_new (_("To:"));
  gtk_widget_ref (to_label);
  gtk_object_set_data_full (GTK_OBJECT (window), "to_label", to_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (to_label);
  gtk_box_pack_start (GTK_BOX (to_box), to_label, FALSE, FALSE, 2);
  gtk_widget_set_usize (to_label, 50, -2);
  gtk_label_set_justify (GTK_LABEL (to_label), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_alignment (GTK_MISC (to_label), 0.9, 0.5);

  to_text = gtk_entry_new ();
  gtk_widget_ref (to_text);
  gtk_object_set_data_full (GTK_OBJECT (window), "to_text", to_text,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_entry_set_text( GTK_ENTRY (to_text), (char *)to.c_str() );
  gtk_widget_show (to_text);
  gtk_box_pack_start (GTK_BOX (to_box), to_text, TRUE, TRUE, 0);


  // CC FIELD
  cc_box = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (cc_box);
  gtk_object_set_data_full (GTK_OBJECT (window), "cc_box", cc_box,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cc_box);
  gtk_box_pack_start (GTK_BOX (vbox1), cc_box, FALSE, TRUE, 0);
  gtk_widget_set_usize (cc_box, 2, 20);
  gtk_container_set_border_width (GTK_CONTAINER (cc_box), 2);

  cc_label = gtk_label_new (_("Cc:"));
  gtk_widget_ref (cc_label);
  gtk_object_set_data_full (GTK_OBJECT (window), "cc_label", cc_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cc_label);
  gtk_box_pack_start (GTK_BOX (cc_box), cc_label, FALSE, FALSE, 2);
  gtk_widget_set_usize (cc_label, 50, -2);
  gtk_label_set_justify (GTK_LABEL (cc_label), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_alignment (GTK_MISC (cc_label), 0.9, 0.5);

  cc_text = gtk_entry_new ();
  gtk_widget_ref (cc_text);
  gtk_object_set_data_full (GTK_OBJECT (window), "cc_text", cc_text,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_entry_set_text( GTK_ENTRY( cc_text), (char *)cc.c_str() );
  gtk_widget_show (cc_text);
  gtk_box_pack_start (GTK_BOX (cc_box), cc_text, TRUE, TRUE, 0);


  // SUBJECT FIELD
  subject_box = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (subject_box);
  gtk_object_set_data_full (GTK_OBJECT (window), "subject_box", subject_box,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (subject_box);
  gtk_box_pack_start (GTK_BOX (vbox1), subject_box, FALSE, TRUE, 0);
  gtk_widget_set_usize (subject_box, 2, 20);
  gtk_container_set_border_width (GTK_CONTAINER (subject_box), 2);

  subject_label = gtk_label_new (_("Subject:"));
  gtk_widget_ref (subject_label);
  gtk_object_set_data_full (GTK_OBJECT (window), "subject_label", subject_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (subject_label);
  gtk_box_pack_start (GTK_BOX (subject_box), subject_label, FALSE, FALSE, 2);
  gtk_widget_set_usize (subject_label, 50, -2);
  gtk_label_set_justify (GTK_LABEL (subject_label), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_alignment (GTK_MISC (subject_label), 0.9, 0.5);

  subject_text = gtk_entry_new ();
  gtk_widget_ref (subject_text);
  gtk_object_set_data_full (GTK_OBJECT (window), "subject_text", subject_text,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_entry_set_text( GTK_ENTRY (subject_text), (char *)subject.c_str() );
  gtk_widget_show (subject_text);
  gtk_box_pack_start (GTK_BOX (subject_box), subject_text, TRUE, TRUE, 0);


  // BUILD BODY TEXT AREA
  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_object_set_data_full (GTK_OBJECT (window), "scrolledwindow1",
			    scrolledwindow1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 4);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
				  GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

  compose_text = gtk_text_new (NULL, NULL);
  gtk_widget_ref (compose_text);
  gtk_object_set_data_full (GTK_OBJECT (window), "compose_text",
			    compose_text,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_text_set_editable (GTK_TEXT (compose_text), TRUE);
  gtk_text_set_word_wrap( GTK_TEXT (compose_text), TRUE );
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), compose_text);
  gtk_text_insert( GTK_TEXT (compose_text), NULL, &compose_text->style->black,
		   NULL, (char*)body.c_str(), -1);
  gtk_widget_show (compose_text);


  // SET UP CALLBACKS
  // close button
  gtk_signal_connect_object( GTK_OBJECT (close_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy), 
                             GTK_OBJECT (window) );

  // send button
  text_widgets *temp = new text_widgets;
  temp->to = GTK_ENTRY (to_text);
  temp->subject = GTK_ENTRY (subject_text);
  temp->cc = GTK_ENTRY (cc_text);
  temp->body = GTK_TEXT (compose_text);
  gtk_signal_connect( GTK_OBJECT (send_button), "clicked",
                      GTK_SIGNAL_FUNC (create_message), temp );
  gtk_signal_connect_object( GTK_OBJECT (send_button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (window) );

  // The attach button opens a file dialog box
  gtk_signal_connect( GTK_OBJECT (attach_button), "clicked",
                      GTK_SIGNAL_FUNC (attach_file), NULL );


  // ADD ACCEL KEYS
  new_accel_group = gtk_accel_group_new();
  
  // S:  Send Message
  if (gAlthea.get_config()->get_key_accelerator(SEND_MESSAGE)) {
  	gtk_widget_add_accelerator(send_button, "clicked", new_accel_group,
			     gAlthea.get_config()->get_key_accelerator(SEND_MESSAGE), GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  }
  else {
  	gtk_widget_add_accelerator(send_button, "clicked", new_accel_group,
			     'S', GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  }
  
  // F:  Attach File
  if (gAlthea.get_config()->get_key_accelerator(ATTACH_FILE)) {
  	gtk_widget_add_accelerator(attach_button, "clicked", new_accel_group,
			     gAlthea.get_config()->get_key_accelerator(ATTACH_FILE), GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  }
  else {
  	gtk_widget_add_accelerator(attach_button, "clicked", new_accel_group,
			     'F', GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  }
  
  // C: Close Message
  if (gAlthea.get_config()->get_key_accelerator(CLOSE_MESSAGE)) {
  	gtk_widget_add_accelerator(close_button, "clicked", new_accel_group,
			     gAlthea.get_config()->get_key_accelerator(CLOSE_MESSAGE), GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  }
  else {
  	gtk_widget_add_accelerator(close_button, "clicked", new_accel_group,
			     'C', GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  }
  
  gtk_window_add_accel_group (GTK_WINDOW (window), new_accel_group);


  gtk_widget_grab_focus( to_text );

  return window;
}
