//
//  SendMail.cpp  --  Wrapper function to send mail.  Now uses smtp.
//  -- created 4/11/00  updated 4/11/00
/////////////////////////////////////////

#include "SendMail.h"

extern Althea gAlthea;

// the maximum length for a line
//  -- we might want to change this so that it is
//  determined by the body type.  ie, 1000 for some
//  encoded thing, but for hujman readable make it
//  76.
const int MAX_LINE_LENGTH = 70;

void getProperDate(string &date)  {
   // given string of the form:
   // Thu May 18 16:38:50 2000 (CDT)\n
   // we want:
   // Thu, 18 May 2000 14:43:43 -0500
   string dayNum;
   string year;


   dayNum = date.substr(8,3);
   year = date.substr(20,5);
   date.erase(20,5);
   date.erase(8,3);
   year.replace(4,1," ");
   if (gAlthea.get_Verbose())
     cout << date << endl;
   // now looks like:
   // Thu May 16:38:50 (CDT)
   date.insert(8,year);
   date.insert(4,dayNum);
   date.insert(3,",");
}

int SendMail(Message *M)  {

   /*********************************************
    * our variables				*
    *********************************************/

   string date;
   string bodyData;
   string tmp;
   string::const_iterator i;
   int lineLength;
   int bodyLengthCounter;
   int bodyPartsCounter;
   int prevSpacePos=0;
   time_t tme;

   // hard code our relevant variables until we get
   // this working in a class
   //
   // so how is this stuff going to be passed in?
   // will it be global? will I have to pass the
   // nameof the server and whatnot to SMTPSend?
   string to = M->get_To_Address();
   string from = M->get_Server_Ptr()->get_EMail_Address(); 
   string subject = M->get_Subject() + "\r\n";
   string CC = M->get_CC_Address();
   string otherHeaders;
   string SMTPServer = M->get_Server_Ptr()->get_SMTP_Server_Name();
   string bodyParts[2];

   otherHeaders =  "X-Mailer: Althea (v";
   otherHeaders += VERSION;
   otherHeaders += ")\r\n";

   bodyParts[0] = M->get_Body_Text();

   /*********************************************
    * check to make sure our message is a	*
    * legitimate RFC 821/822 message		*
    *********************************************/

   // make sure we have all the required headers
   // checks occuring in order of severity, from 
   // most to least

   if (to == "")  {
      // no valid recipient.  
      // not a recoverable error

      // "To field unspecified"
      return(1);
   }

   if (from == "")  {
      // sender not specified.

      // "Sender not specified"
      return(2);
   }
   // make sure lines do not exceed MAX_LINE_LENGTH characters
   // and as long as we are looking at everything,
   // make sure it is all valid US-ASCI.
   //
   // i am not sure whether this is the most efficient method
   // of performing this search ornot.  if there is a better 
   // way, most likely by using substring searches, it can
   // be easily added here without hurting anything else.
   for (bodyPartsCounter=0; 
        bodyPartsCounter < (int)bodyParts[bodyPartsCounter].length(); 
        bodyPartsCounter++)  {
      lineLength = 0;
      for (bodyLengthCounter=0; bodyParts[bodyPartsCounter][bodyLengthCounter];
                      bodyLengthCounter++)  {
         if (bodyParts[bodyPartsCounter][bodyLengthCounter]=='\n')  {
            // here is a newline so let's reset our counter
            lineLength = 0;
	    prevSpacePos = bodyLengthCounter;
         }
	 // ok.  think of all the possible word delimeters.
         else if (bodyParts[bodyPartsCounter][bodyLengthCounter]==' ')  {
            // we have a break between words.
	    // remember this position so our line breaks are 
	    // are quite so random
	    prevSpacePos = bodyLengthCounter;
	 }
         
	 if ((lineLength>MAX_LINE_LENGTH) && 
	     (bodyParts[bodyPartsCounter][bodyLengthCounter]!=' '))  {
            // insert a new line for 'em
	    // and remove any leading spaces on the newline
            //bodyParts[bodyPartsCounter].insert(prevSpacePos,"\r");
	    // ^--- for some reason having this in there, in pine at
	    //      least makes it do double lines.  dunno why.
	    //      would be nice to see if we have this same affect
	    //      in other mail clients as well.
            bodyParts[bodyPartsCounter].insert(prevSpacePos,"\n");
            lineLength = 0;
	    prevSpacePos = bodyLengthCounter;
         }
         else  {
            lineLength++;
         }
      }
   }
   /*********************************************
    * lets get all of our stuff attached	*
    * to the body all nice like			*
    *********************************************/
   // get our date header taken care of.
   // this is a lot uglier then is should be,
   // but I don't know how to do it otherwise.
   // there has to be some command that will 
   // get both the date as well as the time zone,
   // but the stuff from ctime and time.h have
   // the timezone seperated.
   // get the current time, local time.
   time(&tme);
   localtime(&tme);
   tmp = ctime(&tme);

   // the string comes with a \n, lets remove that.
   //tmp[tmp.length()-1] = ' ';
   getProperDate(tmp);
   if (gAlthea.get_Verbose())
     cout << tmp;

   // concatenate all of our date sutff together
   date = "Date: " + tmp + "(" + tzname[1] + ")";
   if (gAlthea.get_Verbose())
     cout << date << endl;

   // add headers
   bodyData = date + "\r\n" + "To: " + to + "\r\n";
   if (CC == "") 
	bodyData += otherHeaders + "Subject: " + subject + "\r\n";
   else
	bodyData += "CC: " + CC + "\r\n" + otherHeaders + "Subject: " + subject + "\r\n";


   // add body

   /* First, you need to turn bare LFs into CR LFs to comply with the
    * standards. We do this by deleting CRs, and turning LFs in to CR
    * LFs. There is probably a better way to do it, but I'm not a C++
    * guy. --CRP
    */
   for (i = bodyParts[0].begin(); i != bodyParts[0].end(); i++)  {
     if (*i == '\r') {
       // drop it
     } else if (*i == '\n') {
       bodyData += "\r\n";
     } else {
       bodyData += *i;
     }
   }


   // Before sending, make sure the recipients are compliant with RFC 821.
   // For example, no quotes!
   string temp_to = *new string();
   string temp_cc = *new string();
   unsigned int counter, quote;
   
   list<string> toaddrs;
   
   int begin=0;
   while (to.find(",",begin)<to.length()) {
     toaddrs.push_back(to.substr(begin,to.find(",",begin)-begin));
     begin=to.find(",",begin)+1;     
   }
   toaddrs.push_back(to.substr(begin,to.length()-begin));

   begin=0;
   while (CC.find(",",begin)<CC.length()) {
     toaddrs.push_back(CC.substr(begin,CC.find(",",begin)-begin));
     begin=CC.find(",",begin)+1;     
   }
   toaddrs.push_back(CC.substr(begin,CC.length()-begin));


   for (list<string>::iterator it = toaddrs.begin();
	it != toaddrs.end();
	it++) {

     if ((*it).find("<")<(*it).length()) {
       (*it)=(*it).substr((*it).find("<")+1,(*it).find(">")-(*it).find("<")-1);
     }



     string temp_temp_to="";
     if ((*it).find("\"")<(*it).length()) {
       quote = 0;
       for (counter = 0; counter < (*it).length(); counter++) {
	 if ((*it)[counter] == '"') {
	   if (quote == 1)
	     quote = 0;
	   else if (quote == 0)
	     quote = 1;
	 }
	 else if (quote == 0) 
	   temp_temp_to += (*it)[counter];
       }
     } else
       temp_temp_to=(*it);
     temp_to+=temp_temp_to+", ";
   }
   

   temp_to=temp_to.substr(0,temp_to.length()-2); // get rid of the final ", "
   /*********************************************
    * send the message				*
    *********************************************/

   int port = 25; // default port number
   string errcodestr;
   int errcode;
   // send via SMTP
   // and return whatever error code SMTPSend
   // may have

   //  Note right now, cc and bcc are not implemented!!

   errcode = SMTPSend(SMTPServer,port,temp_to,temp_cc,"",from,bodyData,errcodestr);
   if (errcode == SUCCESS) {
     if (gAlthea.get_Verbose())
       cout << "message sent" << endl;
   } else {
     if (gAlthea.get_Verbose())
       cout << "Message not sent, or quit error. The error code was: " << errcode << endl;
   }


   // Now get rid of "Date: " to store the value back in Message class
   date = date.substr(6);
   M->set_Date(date);
   return(errcode);
}
