#ifndef _ITEM_H
#define _ITEM_H

#include "strings.h"
#include "mudobject.h"
#include "flags.h"
#include "itemflags.h"
#include "location.h"

class Mobile;

class Item : public MudObject
{
public:

   Item();
   virtual ~Item();

   Flags  *get_itemflags();
   int    set_attrib_itemflags(Parse *the_parsed, Builder *the_builder);
   char   *get_guards();
   void   set_guards(char *the_guards);
   Mobile *is_guarded(Location *the_loc);
   int    set_attrib_guard(Parse *the_parsed, Builder *the_builder);
   void   set_state(int new_state);
   int    get_state();
   int    write_item_attrib(FILE *the_file);
   int    read_item_attrib(FILE *read_file, char *areaname, 
                                                          ErrLog *error_log);
   int copy_item_attrib(Item *copy_from);
   virtual void write_object(FILE *the_file, int build_format);

   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   int     get_mem_size_item();

protected:

   Flags *itemflags;

   Strings guards;
   int     state;

};

#endif
