#include <iostream>
#include <fstream>
#include <vector>
#include <gtkmm.h>
#include "widgets/palettetreemodel.h"
#include "paletteparser/palette.h"

using namespace std;

namespace gcs
{
    bool colorscheme_debug = false;
}

int main(int argc, char** argv)
{
    cout << "setting up Main" << endl;
    Gtk::Main app(argc, argv);
    cout << "Constructing vector container" << endl;
    std::ifstream file("/usr/local/share/agave/palettes/Tango-Palette.gpl");
    pp::Palette palette;
    palette.parse(file);
    cout << palette.size() << " Colors in the palette." << endl;

    cout << "Creating custom treemodel" << endl;
    Glib::RefPtr<gcs::PaletteTreeModel> model = gcs::PaletteTreeModel::create(palette);
    cout << "creating tree view" << endl;
    Gtk::TreeView tree_view(model);
    cout << "Appending column" << endl;
    tree_view.append_column("color", model->get_text_column());
    tree_view.set_headers_visible(true);
    cout << "Adding treeview to window" << endl;
    Gtk::ScrolledWindow scrolled;
    scrolled.add(tree_view);
    cout << "setting up win" << endl;
    Gtk::Window win;
    win.add(scrolled);
    cout << "Showing all" << endl;
    win.show_all();
    app.run(win);
    cout << palette;
    return 0;
}
