/***************************************************************************
                 pluginmanager.cpp  -  the plug in manager
                             -------------------
    begin                : Tue Apr 17 15:46:03 EEST 2001
    copyright            : (C) 2001 by theKompany (www.thekompany.com>
    author               : Eugen Constantinescu
    email                : eug@thekompany.com
 ***************************************************************************/

#include <pluginmanager.h>
#include <kconfig.h>
#include <stdio.h>

extern KConfig *GlobalConfig;

PlugInManager *PlugInManager::inst;

PlugInManager::PlugInManager()
{
  // force creating the kernel
  kernel = Kernel::instance();
  // the service manager
  serviceManager=kernel->serviceManager();
  // create the plug in loader
  plugInLoader = dynamic_cast<PluginLoader*> (serviceManager->registeredProvider("Kore/Kernel/Plugin Loader"));
}

PlugInManager::~PlugInManager()
{
  for(PlugInIt it=plugInList.begin(); it!=plugInList.end(); ++it)
  {
    plugInLoader->closePlugin((*it));
    delete (*it);
  }
  plugInList.clear();
  delete plugInLoader;
  delete kernel;
}

PlugInManager* PlugInManager::thisInstance()
{
  if( !inst )
    inst = new PlugInManager;
  return inst;
}

void PlugInManager::init()
{
  //read the configuration
	QStrList plugIns;

	printf("\n\n\n\ninit plugins\n");

	if( !kernel || !plugInLoader || !serviceManager )
	{
  	printf("\n KORE ERROR \n");
  	fflush(stdout);
	}
	else
	{
  	if( GlobalConfig->hasGroup("PlugInManager") )
  	{
    	GlobalConfig->setGroup("PlugInManager");
    	if( GlobalConfig->readListEntry("PlugIns", plugIns) )
    	{
      	QString defaultDirectory=GlobalConfig->readEntry("PlugInDirectory");

      	printf( defaultDirectory.latin1() );

      	for(QStrListIterator itPlugIn(plugIns); itPlugIn.current(); ++itPlugIn)
        {
          // TODO: checking the plug in
          // openPlugin()
          // if( !check() )
          //   closePlugin()
          printf( "\n plugin: " );
          printf( "%s\n", (*itPlugIn));
          fflush(stdout);

          Plugin* newPlugIn=plugInLoader->runPlugin((*itPlugIn), defaultDirectory.latin1());
          if( newPlugIn )
            plugInList.push_back(newPlugIn);
          else
            cout << "Warning: " << plugInLoader->lastError() << endl;
        }
      }
  	}
  	// initialise with empty values
  	else
  	{
    	GlobalConfig->setGroup("PlugInManager");
    	GlobalConfig->writeEntry("PlugIns", " ");
      GlobalConfig->writeEntry("PlugInDirectory"," ");
  	}
	}
	
}




