/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef HAS_OBJECT_LIST
	#define HAS_OBJECT_LIST

#include <qvaluelist.h>
#include <qtextstream.h>
#include <metaobject.h>

class ObjectDetails
{
	MetaObject *mObj;
	int parentUID;
	int UID;
	int level;
	int nestIndex;
public:
	ObjectDetails(MetaObject *mo=NULL, int uid=-1, 
			int l=-1, int ni=-1, int puid=-1);
	~ObjectDetails() { if(mObj) delete mObj; };
	// get *
	int getLevel() 						{ return level;     };
	int getUID()							{ return UID;       };
	int getNestIndex()				{ return nestIndex; };
	int getParentUID()				{ return parentUID; };
	MetaObject *getObject()		{ return mObj;      };
	// set *
	void setObject(MetaObject *mo)	{ mObj = mo;      };
	void setLevel(int l) 						{ level = l;      };
	void setUID(int uid)						{ UID = uid;      };
	void setNestIndex(int ni)				{ nestIndex=ni;   };
	void setParentUID(int puid)			{ parentUID=puid; };
};

#define DELETE_OP				1


class ObjectsList
{
	QValueList<ObjectDetails *> elements;
	static int localUID;
	void init(QTextStream &str);
	bool indexedOperation(int parent=-1, int operation=DELETE_OP, int offset=0);
public:
	ObjectsList(MetaObject *mo=NULL);
	ObjectsList(QString list);
	~ObjectsList();
	void addObject(MetaObject *mo=NULL, int level=0, int idx=-1, int puid=-1);
	void addObject(QString objstr);
	bool deleteObject(int objectUID); // deletes only if is level=0
	QValueList<int> nameQuery(QString name); // the object's type (VEVENT...)
	MetaObject *operator[] (int uid);
	QString recompose();
	int getLocalUID() { return localUID++; };
	
	
};

#endif








