/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */
 
#include <stdio.h>
#include <qstring.h>
#include <qvaluelist.h>
#include <miscfunctions.h>
#include <metaquality.h>
#include <metaline.h>

//#define DEBUG_META_LINE

#ifdef IDSTRING
#undef IDSTRING
#endif

#define IDSTRING "Metaline:"

MetaLine::MetaLine(QString line)
{
	metaQuality=NULL;
	parse(line);
}

MetaLine::MetaLine(MetaLine &ml)
{
	metaQuality=NULL;
	metaQuality=new MetaQuality(*ml.getQuality());
	name=ml.getName();
	content=ml.getContent();
}

MetaQuality *MetaLine::getQuality()
{
	return metaQuality;
}

QString &MetaLine::getName()
{
	return name;
}

QString &MetaLine::getContent()
{
	return content;
}

void MetaLine::parse(QString line)
{
	// the line should NOT be empty
	QStringList unseparator;
	unseparator.append("\\");
	unseparator.append("http");
	unseparator.append("ftp");
	unseparator.append("mailto");
	unseparator.append("gopher");
	
	QStringList prop_name=enhancedSplit(line,':',unseparator);
	for(int i=2;i<prop_name.count();i++)
	{
		prop_name[1].append(":"+prop_name[i]);
	}
	// the result should be two strings: the property name&qualities
	//                                   the content
	int colonPos=prop_name[0].length();
	int semicolonPos=line.find(';'); // getting the first semicolon
	if(colonPos==-1)
	{
		printf(IDSTRING"parse: ERROR: Invalid line syntax\n");
#ifdef DEBUG_META_LINE
			printf(IDSTRING"parse:        [%s]\n", (const char *)line);
#endif
		// initializing with some default values:
		content="";
		name="";
		return;
	}
	else
	{
		// I have a valid line!
		if(semicolonPos==-1 || semicolonPos>colonPos)
		{
			name=line.left(colonPos);
			content=line.mid(colonPos+1, (line.length()-colonPos-1));
#ifdef DEBUG_META_LINE
				printf(IDSTRING"parse: 1.Field name   : [%s]\n", (const char *)name);
				printf(IDSTRING"parse: 1.Field content: [%s]\n", (const char *)content);
				metaQuality->show();
#endif
		}
		else
		{
			name=line.left(semicolonPos);
			content=line.mid(colonPos+1, (line.length()-colonPos-1));
			metaQuality=new MetaQuality(line.mid(semicolonPos+1, colonPos-semicolonPos-1));
#ifdef DEBUG_META_LINE
				printf(IDSTRING"parse: 2.Field name   : [%s]\n", (const char *)name);
				printf(IDSTRING"parse: 2.Field content: [%s]\n", (const char *)content);
				metaQuality->show();
#endif
		}
	}
	replaceEnters(true);
	#ifdef DEBUG_META_LINE
		printf(IDSTRING"parse: 3.Field name   : [%s]\n", (const char *)name);
		printf(IDSTRING"parse: 3.Field content: [%s]\n", (const char *)content);
		metaQuality->show();
	#endif
}

void MetaLine::replaceEnters(bool flag)
{
	QString source;
	QString dest;
	if(flag==true)
	{
		// replace the sequence "\\n" with an "\n"
		source="\\n";
		dest="\n";
	}
	else
	{
		// replace the sequence "\n" with an "\\n"
		source="\n";
		dest="\\n";
	}
	int pos=0;
	while((pos=content.find(source,pos))!=-1)
	{
		content.replace(pos, source.length(), dest);
	}
}


QString MetaLine::recompose()
{
	text=name;
	if(metaQuality && (metaQuality->count()!=0))
	{
		text+=";";
		text+=metaQuality->recompose();
	}
	text+=":";
	text+=content;
	return text;
}


void MetaLine::addQualities(QString qualities)
{
	MetaQuality addons(qualities);
	for(unsigned i=0;i<addons.count();i++) 
	{
		if(!metaQuality)
			metaQuality=new MetaQuality(qualities);
		else
			metaQuality->appendQuality(addons[i].name(),addons[i].oldContent());
	}
}
void MetaLine::replaceQualities(QString qualities)
{
	MetaQuality addons(qualities);
	for(unsigned i=0;i<addons.count();i++)
		metaQuality->replaceQuality(addons[i].name(),addons[i].oldContent());
}
void MetaLine::eraseQuality(QString qualityName, 
	QString included, QString excluded)
{
	metaQuality->eraseQuality(qualityName, included, excluded);
}
void MetaLine::deleteQualities()
{
	delete metaQuality;
}
bool MetaLine::checkQualities(QString included, QString excluded)
{
	// if I have no specific qualities, then I consider this is the 
	// only line in the list with the name, and therefore is true.
#ifdef DEBUG_METALINE
	printf("checkQualities: Line (%s)\n",(const char *)getName());
#endif
	if(metaQuality==NULL || metaQuality->count()==0)
	{
#ifdef DEBUG_METALINE
		printf("checkQualities: no qualities. plain\n");
#endif
		return TRUE;
	}
#ifdef DEBUG_METALINE
	printf(IDSTRING"checkQualities:included: <%s>\n",
		(const char *)included);
	printf(IDSTRING"checkQualities:excluded: <%s>\n",
		(const char *)excluded);
#endif	
	MetaQuality includedQualities(included);
	MetaQuality excludedQualities(excluded);
	if(!included.isEmpty())
	{
	// for each included quality...
		for(unsigned i=0;i<includedQualities.count();i++)
		{
#ifdef DEBUG_METALINE
			printf(IDSTRING"checkQualities:I name:    %s\n",
					(const char *)includedQualities[i].name());
			printf(IDSTRING"checkQualities:I content: %s\n",
					(const char *)includedQualities[i].oldContent());
#endif
			if(metaQuality->query(
					includedQualities[i].name(),includedQualities[i].oldContent())==FALSE)
				return FALSE;
		}
	}
	if(!excluded.isEmpty())
	{
	// for each excluded quality...
		for(unsigned i=0;i<excludedQualities.count();i++)
		{
#ifdef DEBUG_METALINE
			printf(IDSTRING"checkQualities:X name:    %s\n",
					(const char *)excludedQualities[i].name());
			printf(IDSTRING"checkQualities:X content: %s\n",
					(const char *)excludedQualities[i].oldContent());
#endif
			if(metaQuality->query(
					excludedQualities[i].name(),
					QString::null,excludedQualities[i].oldContent())==TRUE)
				return FALSE;
		}
	}
	return TRUE;
}




