/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <attributemarshall.h>

_Attribute::~_Attribute()
{
	// nothing here
}

QString _Attribute::type()
{
	return "attribute";
}

QString _MailAttribute::type()
{
	return "mailattribute";
}

QString _BlockObjectAttribute::type()
{
	return "blockobjectattribute";
}

QString _FolderAttribute::type()
{
	return "folderattribute";
}

QString _PartAttribute::type()
{
	return "partattribute";
}

QDataStream& operator<<(QDataStream &stream, _Attribute &attr)
{
	stream<<attr.type()<<attr.owner<<attr.device<<attr.dtype<<attr.rtype<<attr.size<<attr.lmodified<<attr.active<<attr.flags;
	return stream;
}

QDataStream& operator>>(QDataStream &stream, _Attribute &attr)
{
	QString _type;
	stream>>_type>>attr.owner>>attr.device>>attr.dtype>>attr.rtype>>attr.size>>attr.lmodified>>attr.active>>attr.flags;
	return stream;
}

QDataStream& operator<<(QDataStream &stream, _MailAttribute &attr)
{
	stream<<(_Attribute &)attr;
	stream<<attr.uniblockOffset;
	stream<<attr.uniblockLength;
	stream<<attr.descriptorOffset;
	stream<<attr.descriptorLength;
	stream<<attr.partCount;
	stream<<attr.multipartOnly;
	return stream;
}

QDataStream& operator>>(QDataStream &stream, _MailAttribute &attr)
{
	stream>>(_Attribute &)attr;
	stream>>attr.uniblockOffset;
	stream>>attr.uniblockLength;
	stream>>attr.descriptorOffset;
	stream>>attr.descriptorLength;
	stream>>attr.partCount;
	stream>>attr.multipartOnly;
	return stream;
}

QDataStream& operator<<(QDataStream &stream, _BlockObjectAttribute &attr)
{
	stream<<(_Attribute &)attr;
	stream<<attr.offset;
	return stream;
}

QDataStream& operator>>(QDataStream &stream, _BlockObjectAttribute &attr)
{
	stream>>(_Attribute &)attr;
	stream>>attr.offset;
	return stream;
}

QDataStream& operator<<(QDataStream &stream, _FolderAttribute &attr)
{
	stream<<(_Attribute &)attr;
	stream<<attr.items<<attr.recent<<attr.folders;
	return stream;
}

QDataStream& operator>>(QDataStream &stream, _FolderAttribute &attr)
{
	stream>>(_Attribute &)attr;
	stream>>attr.items>>attr.recent>>attr.folders;
	return stream;
}

QDataStream& operator<<(QDataStream &stream, _PartAttribute &attr)
{
	stream<<(_Attribute &)attr;
	stream<<attr.mimetype;
	stream<<attr.name;
	stream<<attr.cid;
	stream<<attr.encoding;
	stream<<attr.charset;
	stream<<attr.mtype;
	stream<<attr.partOffset;
	stream<<attr.partLength;
	stream<<attr.embeddedPath;
	return stream;
}

QDataStream& operator>>(QDataStream &stream, _PartAttribute &attr)
{
	stream>>(_Attribute &)attr;
	stream>>attr.mimetype;
	stream>>attr.name;
	stream>>attr.cid;
	stream>>attr.encoding;
	stream>>attr.charset;
	stream>>attr.mtype;
	stream>>attr.partOffset;
	stream>>attr.partLength;
	stream>>attr.embeddedPath;
	return stream;
}

QByteArray _stream(_Attribute &attr)
{
  QByteArray data;
  QDataStream stream(data, IO_WriteOnly);
  stream<<attr;
  return data;
}

QByteArray _stream(_MailAttribute &attr)
{
  QByteArray data;
  QDataStream stream(data, IO_WriteOnly);
  stream<<attr;
  return data;
}

QByteArray _stream(_FolderAttribute &attr)
{
  QByteArray data;
  QDataStream stream(data, IO_WriteOnly);
  stream<<attr;
  return data;
}

QByteArray _stream(_BlockObjectAttribute &attr)
{
  QByteArray data;
  QDataStream stream(data, IO_WriteOnly);
  stream<<attr;
  return data;
}

QByteArray _stream(_PartAttribute &attr)
{
  QByteArray data;
  QDataStream stream(data, IO_WriteOnly);
  stream<<attr;
  return data;
}

_Attribute _narrowAttribute(const QByteArray &data)
{
  QDataStream stream(data, IO_ReadOnly);
  _Attribute attr;
  stream>>attr;
  return attr;
}

_MailAttribute _narrowMailAttribute(const QByteArray &data)
{
  QDataStream stream(data, IO_ReadOnly);
  _MailAttribute attr;
  stream>>attr;
  return attr;
}

_FolderAttribute _narrowFolderAttribute(const QByteArray &data)
{
  QDataStream stream(data, IO_ReadOnly);
  _FolderAttribute attr;
  stream>>attr;
  return attr;
}

_BlockObjectAttribute _narrowBlockObjectAttribute(const QByteArray &data)
{
  QDataStream stream(data, IO_ReadOnly);
  _BlockObjectAttribute attr;
  stream>>attr;
  return attr;
}

_PartAttribute _narrowPartAttribute(const QByteArray &data)
{
  QDataStream stream(data, IO_ReadOnly);
  _PartAttribute attr;
  stream>>attr;
  return attr;
}
