/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <qheader.h>
#include <qvaluelist.h>
#include <qstring.h>
#include <elistview.h>

#define IDSTRING "EListView: "

//#define DEBUG_ELV

EListDims::EListDims(int type, double width)
{
	setType(type);
	setSize(width);
}

void EListDims::setType(int item) { _type=item; }
void EListDims::setSize(double item) { _size=item; }
int EListDims::type() { return _type; }
double EListDims::size() { return _size; }


EListView::EListView(QWidget *parent, const char *name) : QListView(parent,name)
{
	isResizing=false;
	numPercentLines=minWidth=0;
	setAllColumnsShowFocus(true);
	setHScrollBarMode(AlwaysOff);
	connect(header(), SIGNAL(sizeChange(int, int, int)), this, SLOT(columnsResize(int, int, int)));
}
void EListView::columnsResize(int section, int oldSize, int newSize)
{
#ifdef DEBUG_ELV
	printf(IDSTRING"column has been resized\n");
#endif
	manualResize(section, oldSize, newSize);
}

void EListView::addColumn(QString label, int type, int perc)
{
	columnSizes.append(EListDims(type,perc));
	if(type==EListDims::Percent)
		numPercentLines++;
	else
	{
		minWidth+=perc;
		setMinimumWidth(minWidth);
	}
	int i=0;
	length.append(i);
	compute(width());
	QListView::addColumn(label);
	setColumnWidthMode(columns()-1, Manual);
	setColumnWidth(columns()-1, perc);
	if(type==EListDims::Fixed)
	{
		header()->setResizeEnabled(false, header()->mapToSection(columns()-1));
	}
}


void EListView::compute(int len)
{
#ifdef DEBUG_ELV
	printf(IDSTRING"Computing... %d\n", len);
#endif
	len=len-((verticalScrollBar()->isVisible())?verticalScrollBar()->width():0);
	int relLength=len;
	for(int i=0;i<columnSizes.count();i++)
	{
		if (columnSizes[i].type()==EListDims::Fixed)
		{
			relLength-=(int)columnSizes[i].size();
			length[i]=(int)columnSizes[i].size();
		}
	}
	if(relLength<0)
	{
#ifdef DEBUG_ELV
		printf(IDSTRING" Too small\n");
#endif
		return;
	}
	double totalPercentages=0.0;
	for(int i=0;i<columnSizes.count();i++)
	{
		if (columnSizes[i].type()==EListDims::Percent)
			totalPercentages+=columnSizes[i].size();
	}
	if(totalPercentages==0.0)
		return;
	double percentages=100.0/totalPercentages;
	double offset;
	int c=0;
	int consumed=0;
	for(int i=0;i<columnSizes.count();i++)
	{
		if(columnSizes[i].type()==EListDims::Percent)
		{
			c++;
			if(c==numPercentLines)
				length[i]=relLength-consumed;
			else
			{
				length[i]=(int)(relLength*percentages/100.0*columnSizes[i].size());
				consumed+=length[i];
			}
		}
	}
	for(int i=0;i<columnSizes.count();i++)
	{
		if(columnSizes[i].type()==EListDims::Percent)
			setColumnWidth(i,length[i]);
#ifdef DEBUG_ELV
		printf(IDSTRING"\tline[%d] is <%d>\n",i, length[i]);
#endif
	}
}

void EListView::paintEvent(QPaintEvent *)
{
#ifdef DEBUG_ELV
	printf(IDSTRING"doPaint\n");
#endif
	compute(width());
}

void EListView::manualResize(int index, int oldSize, int newSize)
{
#ifdef DEBUG_ELV
	printf(IDSTRING"Resizing %d: %d -> %d\n", index, oldSize, newSize);
#endif
	// computing the new percent..
	int w=width();
	w-=minWidth;
	double deltaperc=columnSizes[index].size()*((double)(oldSize-newSize))/length[index];
#ifdef DEBUG_ELV
	printf(IDSTRING"\t\tperc(%d) is <%f>\n",index, deltaperc);
#endif
	for(int i=0;i<columnSizes.count();i++)
	{
		if(columnSizes[i].type()==EListDims::Percent)
			if(i==index)
				columnSizes[i].setSize(columnSizes[i].size()-deltaperc);
			else
				columnSizes[i].setSize(columnSizes[i].size()+deltaperc);
	}
#ifdef DEBUG_ELV
	double total=0;
	for(int i=0;i<columnSizes.count();i++)
	{
		if(columnSizes[i].type()==EListDims::Percent)
			total+=columnSizes[i].size();
		printf(IDSTRING"\tline[%d] is <%f>\n",i, columnSizes[i].size());
	}
		printf(IDSTRING"\tTOTAL <%f>\n",total);
#endif
	compute(w);
}
