/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __Has_CardClasses__
#define __Has_CardClasses__


#include <qstring.h>
#include <qstringlist.h>
#include <qdict.h>
#include <qvaluelist.h>


class CardAddress
{
	public:
		CardAddress();

		QString poBox();
		QString streetName();
		QString details();
		QString code();
		QString city();
		QString country();

		void setPoBox(QString newItem);
		void setStreetName(QString newItem);
		void setDetails(QString newItem);
		void setCode(QString newItem);
		void setCity(QString newItem);
		void setCountry(QString newItem);
		
		void clear();
		
	private:
		QString _poBox, _streetName, _details, _code, _city, _country;
};

class CardPhone
{
	public:
		CardPhone();
		
		QString &type();
		QString &number();
		
		void setType(QString newItem);
		void setNumber(QString newItem);
	private:
		QString _type, _number;
};


class CardListPhones
{
	public:
		CardListPhones();
		~CardListPhones();
		void addPhone(CardPhone *phone);
		void removePhone(QString phoneNumber);
		void removePhone(int);
		QValueList<CardPhone *> phones();
		CardPhone *phone(QString number);
		int count();
	private:
		QDict<CardPhone> _phones;
};

class CardListEmails
{
	public:
		CardListEmails();
		void addEmail(QString address, bool isDefault=false);
		void setDefaultEmail(int);
		void removeEmail(QString);
		void removeMail(int);
		QStringList &emails();
		int defaultEmail();
	private:
		int _defaultEmail;
		QStringList _emails;
};


class CardBusinessElements
{
	public:
		CardBusinessElements();
		~CardBusinessElements();
		QString &title();
		QString &role();
		QString &org();
		CardListPhones &phones();
		CardListEmails *emails();
		QStringList *urls();
		CardAddress &address();

		void setTitle(QString);
		void setRole(QString);
		void setOrg(QString);
		void setPhones(CardListPhones *);
		void setEmails(CardListEmails *);
		void setUrls(QStringList *);
		void setAddress(CardAddress);
		
		void clear();
	private:
		QString _title;
		QString _role;
		QString _org;
		CardListPhones *_phones;
		CardListEmails *_emails; // common to 2 widgets
		QStringList *_urls; // common to 2 widgets
		CardAddress _address;
};

class CardPersonalElements
{
	public:
		CardPersonalElements();
		~CardPersonalElements();
		QString &card();
		QString &prefix();
		QString &familyName();
		QString &initial();
		QString &name();
		QString &nick();
		CardListPhones &phones();
		CardListEmails *emails();
		QStringList *urls();
		CardAddress &address();

		void setCard(QString);
		void setPrefix(QString);
		void setFamilyName(QString);
		void setInitial(QString);
		void setName(QString);
		void setNick(QString);
		void setPhones(CardListPhones *);
		void setEmails(CardListEmails *);
		void setUrls(QStringList *);
		void setAddress(CardAddress);
		
		void clear();
		
	private:
		QString _card, _prefix, _familyName, _name, _initial;
		QString _nick;
		CardListPhones *_phones;
		CardListEmails *_emails; // common to 2 widgets
		QStringList *_urls; // common to 2 widgets
		CardAddress _address;
};


class CardOtherElements
{
	public:
		CardOtherElements();
		QString bday();
		QString categories();
		QString security();
		QString notes();
		void setBday(QString);
		void setCategories(QString);
		void setSecurity(QString);
		void setNotes(QString);
		
		void clear();
	private:
		QString _bday, _categories, _security, _notes;
};
#endif
