/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <cardclasses.h>

CardAddress::CardAddress()
{
	_poBox=QString::null;
	_streetName=QString::null;
	_details=QString::null;
	_code=QString::null;
	_city=QString::null;
	_country=QString::null;
}

QString CardAddress::poBox() 			{ return _poBox; }
QString CardAddress::streetName() { return _streetName; }
QString CardAddress::details() 		{ return _details; }
QString CardAddress::code() 			{ return _code; }
QString CardAddress::city() 			{ return _city; }
QString CardAddress::country() 		{ return _country; }

void CardAddress::setPoBox(QString newItem) 			{ _poBox=newItem; }
void CardAddress::setStreetName(QString newItem)	{ _streetName=newItem; }
void CardAddress::setDetails(QString newItem) 		{ _details=newItem; }
void CardAddress::setCode(QString newItem) 				{ _code=newItem; }
void CardAddress::setCity(QString newItem) 				{ _city=newItem; }
void CardAddress::setCountry(QString newItem) 		{ _country=newItem; }

void CardAddress::clear()
{
	_poBox = _streetName = _details = _code = _city = _country = "";
}

/*                   Card Phone Class                  */
CardPhone::CardPhone()
{
	_type=QString::null;
	_number=QString::null;
}

QString &CardPhone::type() 	{ return _type; }
QString &CardPhone::number() { return _number; }

void CardPhone::setType(QString newItem) 		{ _type=newItem; }
void CardPhone::setNumber(QString newItem) 	{ _number=newItem; }

/*                  Card List Phones                   */
#ifdef IDSTRING
	#undef IDSTRING
#endif
#define IDSTRING "CardListPhones: "
CardListPhones::CardListPhones()
{
//	_phones.setAutoDelete(true);
	_phones.clear();
}
CardListPhones::~CardListPhones()
{
	QValueList<CardPhone *> p;
	p=phones();
	for(int i=0;i<p.count();i++)
		delete p[i];
}
void CardListPhones::addPhone(CardPhone *phone)
{
	if(!phone)
	{
		printf(IDSTRING"Empty phone data. Nothing happens.\n");
		return;
	}
	_phones.insert(phone->number(), phone);
}

void CardListPhones::removePhone(QString phoneNumber)
{
	_phones.remove(phoneNumber);
}

CardPhone *CardListPhones::phone(QString number)
{
	return _phones[number];
}

int CardListPhones::count()
{
	return _phones.count();
}

void CardListPhones::removePhone(int index)
{
	QDictIterator<CardPhone> it(_phones);
	int i=0;
	QString result;
	while(it.current())
	{
		if(i==index)
		{
			result=it.currentKey();
			_phones.remove(result);
			return;
		}
		++it;
	}
	printf(IDSTRING"Invalid index value (%d). Nothing happens.\n", index);
}

QValueList<CardPhone *> CardListPhones::phones()
{
	QValueList<CardPhone *> result;
	QDictIterator<CardPhone> it(_phones);
	while(it.current())
	{
		result.append(it.current());
		++it;
	}
	return result;
}

/*                   Card List Emails Class                  */
#ifdef IDSTRING
	#undef IDSTRING
#endif
#define IDSTRING "CardListEmails: "
CardListEmails::CardListEmails()
{
	_defaultEmail=-1; // no mail!
// 	_emails.clear(); // NOT NEEDED
}

void CardListEmails::addEmail(QString address, bool isDefault=false)
{
	int mailindex=_emails.findIndex(address.stripWhiteSpace());
	if(mailindex==-1)
	{
		_emails.append(address);
		mailindex=_emails.count()-1;
	}
	if(isDefault)
		_defaultEmail=mailindex;
}

void CardListEmails::removeEmail(QString address)
{
	int mailindex=_emails.findIndex(address);
	if(mailindex!=-1)
		_emails.remove(address);
}

void CardListEmails::removeMail(int index)
{
	if(index>=_emails.count())
		return;
	QString address=_emails[index];
	int mailindex=_emails.findIndex(address);
	if(mailindex!=-1)
		_emails.remove(address);
}

QStringList &CardListEmails::emails() { return _emails; }
int CardListEmails::defaultEmail() { return _defaultEmail; }
void CardListEmails::setDefaultEmail(int index) { _defaultEmail=index; }

/*                   Business Card Class                  */
#ifdef IDSTRING
	#undef IDSTRING
#endif
#define IDSTRING "CardBusinessElements: "

CardBusinessElements::CardBusinessElements()
{
	_emails=0;
	_urls=0;
}
CardBusinessElements::~CardBusinessElements()
{
	delete _phones;
}
QString &CardBusinessElements::title() 					{ return _title; }
QString &CardBusinessElements::role() 					{ return _role; }
QString &CardBusinessElements::org() 						{ return _org; }
CardListPhones &CardBusinessElements::phones() 	{ return *_phones; }
CardListEmails *CardBusinessElements::emails() 	{ return _emails; }
QStringList *CardBusinessElements::urls() 			{ return _urls; }
CardAddress &CardBusinessElements::address() 		{ return _address; }

void CardBusinessElements::setTitle(QString newItem) 					{ _title=newItem; }
void CardBusinessElements::setRole(QString newItem) 					{ _role=newItem; }
void CardBusinessElements::setOrg(QString newItem) 						{ _org=newItem; }
void CardBusinessElements::setPhones(CardListPhones *newItem) { _phones=newItem; }
void CardBusinessElements::setEmails(CardListEmails *newItem) { _emails=newItem; }
void CardBusinessElements::setUrls(QStringList *newItem) 			{ _urls=newItem; }
void CardBusinessElements::setAddress(CardAddress newItem) 		{ _address=newItem; }

void CardBusinessElements::clear()
{
	_title = _org = _role = "";
	delete _phones;
	_phones=0;
	_address.clear();
}

/*                   Personal Card Class                  */
#ifdef IDSTRING
	#undef IDSTRING
#endif
#define IDSTRING "CardPersonalElements: "

CardPersonalElements::CardPersonalElements()
{
	_emails=0;
	_urls=0;
}
CardPersonalElements::~CardPersonalElements()
{
	delete _phones;
}
QString &CardPersonalElements::card() 						{ return _card; }
QString &CardPersonalElements::prefix() 					{ return _prefix; }
QString &CardPersonalElements::familyName() 			{ return _familyName; }
QString &CardPersonalElements::name() 						{ return _name; }
QString &CardPersonalElements::initial() 					{ return _initial; }
QString &CardPersonalElements::nick() 						{ return _nick; }
CardListPhones &CardPersonalElements::phones() 		{ return *_phones; }
CardListEmails *CardPersonalElements::emails() 		{ return _emails; }
QStringList *CardPersonalElements::urls() 				{ return _urls; }
CardAddress &CardPersonalElements::address() 			{ return _address; }

void CardPersonalElements::setCard(QString newItem) 					{ _card=newItem; }
void CardPersonalElements::setPrefix(QString newItem) 				{ _prefix=newItem; }
void CardPersonalElements::setFamilyName(QString newItem) 		{ _familyName=newItem; }
void CardPersonalElements::setInitial(QString newItem) 				{ _initial=newItem; }
void CardPersonalElements::setName(QString newItem) 					{ _name=newItem; }
void CardPersonalElements::setNick(QString newItem) 					{ _nick=newItem; }
void CardPersonalElements::setPhones(CardListPhones *newItem) { _phones=newItem; }
void CardPersonalElements::setEmails(CardListEmails *newItem) { _emails=newItem; }
void CardPersonalElements::setUrls(QStringList *newItem) 			{ _urls=newItem; }
void CardPersonalElements::setAddress(CardAddress newItem) 		{ _address=newItem; }

void CardPersonalElements::clear()
{
	_card = _prefix = _familyName = _name = _initial = _nick="";
	delete _phones;
	_phones=0;
	_address.clear();
}

/*                   Other Card Class                  */
#ifdef IDSTRING
	#undef IDSTRING
#endif
#define IDSTRING "CardOtherElements: "
CardOtherElements::CardOtherElements() { }
QString CardOtherElements::bday() 			{ return _bday; }
QString CardOtherElements::categories() { return _categories; }
QString CardOtherElements::security() 	{ return _security; }
QString CardOtherElements::notes() 			{ return _notes; }
void CardOtherElements::setBday(QString newItem) 				{ _bday=newItem; }
void CardOtherElements::setCategories(QString newItem) 	{ _categories=newItem; }
void CardOtherElements::setSecurity(QString newItem) 		{ _security=newItem; }
void CardOtherElements::setNotes(QString newItem) 			{ _notes=newItem; }

void CardOtherElements::clear()
{
	_bday = _categories = _security = _notes = "";
}


