/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <stdio.h>

#include <group.h>


#ifdef IDSTRING
	#undef IDSTRING
#endif
#define IDSTRING	"VGroup: "


VGroup::VGroup(QString groupLine)
{
	QStringList result;
	QString addresslist;
	groupName=QString::null;
	if(groupLine==QString::null)
		return;
	result=QStringList::split(':',groupLine);
	groupName=result[0];
	result=QStringList::split(',',result[1]);
	for(int i=0;i<result.count();i++)
		members.append(result[i].stripWhiteSpace());
	members.sort();
}

void VGroup::changeGroupName(QString newName=QString::null)
{
	if(newName) groupName=newName;
}

void VGroup::eraseAddress(QString address=QString::null)
{
	if(address==QString::null)
	{
		members.clear();
		return;
	}
#ifdef DEBUG_VGROUP
	printf(IDSTRING"removing one address.\n",(const char *)address);
#endif
	members.remove(address);
}

void VGroup::eraseAddress(int address)
{
	if(address<members.count())
		members.remove(members.at(address));
}

void VGroup::addAddress(QString address)
{
	// first check if the addres is already in the list
	if(members.grep(address,false).count()!=0)
		return;
#ifdef DEBUG_VGROUP
	printf(IDSTRING"Address \"%s\" not in the list.\n",(const char *)address);
#endif
	members.append(address);
	members.sort();
}

QString VGroup::getCommaList()
{
	if(members.count()==0)
		return QString::null;
	QString result=members[0];
	for(int i=1;i<members.count();i++)
	{
		result.append(", ");
		result.append(members[i]);
	}
	return result;
}

QStringList VGroup::getAddressList()
{
	return members;
}

QString VGroup::getGroupName()
{
	return groupName;
}

QString VGroup::recompose()
{
	QString result="";
	result.append(groupName);
	result.append(":");
	result.append(getCommaList());
	return result;
}






