/*
    Copyright (C) 2003-2008 Fons Adriaensen <fons@kokkinizita.net>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __IMIDI_H
#define __IMIDI_H


#include <stdlib.h>
#include <stdio.h>
#include <clthreads.h>
#include <alsa/asoundlib.h>
#include "lfqueue.h"
#include "messages.h"



class Imidi : public A_thread
{
public:

    Imidi (Lfq_u32 *qnote, Lfq_u8 *qmidi, uint16_t *midimap, const char *appname);
    virtual ~Imidi (void);

    void terminate (void);

private:

    virtual void thr_main (void);

    void open_midi (void);
    void close_midi (void);
    void proc_midi (void);
    void proc_mesg (ITC_mesg *M);

    Lfq_u32        *_qnote; 
    Lfq_u8         *_qmidi; 
    uint16_t       *_midimap;
    const char     *_appname;
    snd_seq_t      *_handle;
    int             _client;
    int             _ipport;
    int             _opport;
};


#endif

