(in-package "ACL2")

(include-book "rem")

(local (include-book "bits2"))
(local (include-book "bitn"))
(local (include-book "mod2"))
(local (include-book "mod-expt"))
(local (include-book "fl-expt"))
(local (include-book "expt2"))
(local (include-book "expt"))
(local (include-book "expo"))
(local (include-book "expo2"))
(local (include-book "product"))
(local (include-book "rationalp"))

#| old

(defun BITS (x i j)
  (fl (/ (mod x (expt 2 (1+ i))) (expt 2 j))))



|#

(defun bits (x i j)
  (if (or (not (integerp i))
          (not (integerp j)))
      0
  (fl (/ (mod x (expt 2 (1+ i))) (expt 2 j)))))

(defun bitn (x n)
  (bits x n n))
(in-theory (disable bitn))

#| old:
(defun BITN (x n)
  (if (logbitp n x) 1 0))
|#

(defthm bits-with-indices-in-the-wrong-order
  (implies (< i j)
           (equal (bits x i j)
                  0)))


;get rid of this (see where it's used)
(defthm bitn-def-4
  (equal (equal (mod x 2) 0)
         (evenp x))
  )

(in-theory (disable bitn-def-4))


(defthm bitn-def
  (implies (case-split (integerp k))
           (equal (bitn x k)
                  (mod (fl (/ x (expt 2 k)))
                       2)))
  :hints (("Goal" :in-theory (enable bitn-def-mod)))
)

(in-theory (disable bitn-def))


(defthm BITN-ALT-0
  (implies (integerp x)
           (equal (bitn x 0)
                  (mod x 2)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bitn-def (k 0))))))

;takes a while
(defthm BITN-ALT-POS
  (implies (and (integerp x)
                (integerp k)
                (>= x 0)
                (> k 0)
                )
           (equal (bitn x k)
                  (bitn (fl (/ x 2)) (1- k))))
  :rule-classes ()
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable bitn-def expt-split)
                              '(; bitn-def
                                      FL-SHIFT-FL  
                                      MOD-PULL-INSIDE-FL-SHIFT-ALT-ALT-ALT
                                      MOD-PULL-INSIDE-FL-SHIFT-ALT-ALT-ALT-ALT))
           :use ((:instance fl/int-rewrite (x (/ x 2)) (n (expt 2 (1- k))))))))

(defthm BIT-MOD
  (implies (and (< k n)
                (integerp n)
                (integerp k)
                )
           (equal (bitn (mod x (expt 2 n)) k)
                  (bitn x k)))
;  :rule-classes ()
  :hints (("Goal"; :cases ((integerp n))
           :in-theory (enable bitn bits))))

(in-theory (disable BIT-MOD))

(defthm BIT-EXPO-A
  (implies (and (< x (expt 2 n))
                (>= x 0)
                (integerp n)
                )
           (equal (bitn x n) 0))
  :rule-classes ())

(defthm BIT-EXPO-B
  (implies (and (rationalp x)
                (integerp n)
                (>= x 0)
                (>= n 0)
                (<= (expt 2 n) x)
                (< x (expt 2 (1+ n))))
           (equal (bitn x n) 1))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable expt-split bitn-def)
           :use ((:instance fl-unique (x (/ x (expt 2 n))) (n 1))))))

(local (in-theory (enable expt-split)))



(defthm BIT+-A
  (implies (and (integerp x)
                (integerp n)
                (>= x 0)
                (>= n 0))
           (not (equal (bitn (+ x (expt 2 n)) n)
                       (bitn x n))))
  :rule-classes ()
)

(defthm BIT+-B
  (implies (and (integerp x)
                (integerp n)
                (integerp m)
                (>= x 0)
                (> m n)
                (>= n 0))
           (equal (bitn (+ x (expt 2 m)) n)
                  (bitn x n)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bitn))))

(defun SHL (x s n)
  (mod (+ (* 2 x) s) (expt 2 n)))

(defun SHR (x s n)
  (+ (fl (/ x 2)) (* (expt 2 (1- n)) s)))

(defun bits (x i j)
  (if (or (not (integerp i))
          (not (integerp j)))
      0
  (fl (/ (mod x (expt 2 (1+ i))) (expt 2 j)))))

(defun bvecp (x k)
  (and (integerp x)
       (>= x 0)
       (< x (expt 2 k))))

(encapsulate
 ()
 (local (include-book "bits2"))

;proved in bits2.lisp 
 (defthm bits-nonnegative-integerp-type
   (and (<= 0 (bits x i j))
        (integerp (bits x i j)))
   :rule-classes (:type-prescription))
 
;this rule is no better than bits-nonnegative-integer-type and might be worse
 (in-theory (disable (:type-prescription bits)))

;proved in bits2.lisp 
 (defthm bits<
   (< (bits x i j) (expt 2 (- (1+ i) j))))

;proved in bits2.lisp 
 (defthm bits-bvecp
   (implies (and (<= (+ 1 i (- j)) n)
                 (case-split (integerp n))
                 )
            (bvecp (bits x i j) n))))

(defthm MOD-BITS
  (implies (equal (mod x (expt 2 (1+ i))) (mod y (expt 2 (1+ i))))
           (equal (bits x i j) (bits y i j)))
  :hints (("Goal" :in-theory (enable bits)))
  :rule-classes ())


(local (in-theory (disable integerp-prod)))

(local (in-theory (disable MOD-PULL-INSIDE-FL-SHIFT-ALT-ALT-ALT
                           MOD-PULL-INSIDE-FL-SHIFT-ALT
                           MOD-PULL-INSIDE-FL-SHIFT-ALT-ALT
                           MOD-PULL-INSIDE-FL-SHIFT-ALT-ALT-ALT-alt)))




(local (in-theory (disable  MOD-DROP-IRRELEVANT-SECOND-TERM)))


(defthm BIT-BITS-A
  (implies (and (<= k j)
                (integerp i)
                (integerp j)
                (integerp k)
                )
           (= (bits (fl (/ x (expt 2 k)))
                    (- i k)
                    (- j k))
              (bits x i j)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits))))


;(local (in-theory (disable mod-mod-e)))

;(local (in-theory (disable mod-equal)))

(local (in-theory (disable bitn-def)))

;this is the most interesting case. perhaps add the other cases for k<0 and k>i-j
(defthm bitn-bits
  (implies (and (<= k (- i j))
                (case-split (<= 0 k))
                (case-split (integerp i))
                (case-split (integerp j))
                (case-split (integerp k))
                )
           (equal (bitn (bits x i j) k)
                  (bitn x (+ j k))))
  :hints (("Goal" :in-theory (enable bitn bits))))
(in-theory (disable bitn-bits)) ;why?


(defthm bits-bits-1
  (implies (and (<= k (- i j))
                (case-split (<= 0 l))
                (case-split (integerp i))
                (case-split (integerp j))
                (case-split (integerp k))
                (case-split (integerp l))
                )
           (= (bits (bits x i j) k l)
              (bits x (+ k j) (+ l j))))
  :hints (("Goal" :in-theory (enable bits))))
(in-theory (disable bits-bits-1)) ;why?

(defthm bits-bits-2
  (implies (and (> k (- i j))
                (case-split (<= 0 l))
;                (case-split (integerp i))
                (case-split (integerp j))
                (case-split (integerp k))
                (case-split (integerp l))
                )
           (equal (bits (bits x i j) k l)
                  (bits x i (+ l j))))
  :hints (("Goal" :in-theory (enable bits))))
(in-theory (disable bits-bits-2)) ;why?

(defthm bits-bits
  (implies (and (case-split (<= 0 l))
                (case-split (integerp i))
                (case-split (integerp j))
                (case-split (integerp k))
                (case-split (integerp l))
                )
           (equal (bits (bits x i j) k l)
                  (if (<= k (- i j))
                      (bits x (+ k j) (+ l j))
                    (bits x i (+ l j)))))
:hints (("Goal" :in-theory (enable bits-bits-1 bits-bits-2))))
(in-theory (disable bits-bits)) ;why?

(defthm bits-reduce
  (implies (and (< x (expt 2 (+ 1 i)))
                (case-split (integerp x))
                (case-split (<= 0 x))
                (case-split (integerp i))
                (case-split (<= 0 i))
                )
           (equal (bits x i 0) x)))

(defthm bits-natp
  (natp (bits x i j)))

;moved from divsqrt (was a copy in merge, now killed)
(defthm bitn-0-1
    (or (equal (bitn x n) 0)
        (equal (bitn x n) 1))
  :rule-classes ()
  :hints (("goal" :in-theory (enable bitn))))


; no hyps, unlike the version about bits
(defthm bitn-nonnegative-integer-type
  (and (<= 0 (bitn x n))
       (integerp (bitn x n)))
  :rule-classes (:type-prescription))

;this rule is no better than bitn-nonnegative-integer-type and might be worse
(in-theory (disable (:type-prescription bitn)))

(defthm bitn-natp
  (natp (bitn x n)))

(defthm bitn-bvecp
  (implies (and (<= 1 k)
                (case-split (integerp k)))
           (bvecp (bitn x n) k)))

(defthm bitn-0
  (equal (bitn 0 k) 0))

(defthm bits-0
  (equal (bits 0 i j) 0))

