/* ------------------------------------------------------------------------
 * $Id: User.cc,v 1.1 2001/08/16 11:32:24 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-08-15 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- System Includes
#include <unistd.h>
#include <sys/types.h>

// -- Local Includes
#include "Exception.hh"
#include "User.hh"

// -- Code Segment

User::User(int uid)
{
    // Look up the correct user id if necessary
    if (uid == -1) uid = getuid();
    
    // Now look up the password entry
    if ((_pwd = getpwuid(uid)) == 0)
	throw Exception("username not found");
}

User::User(const std::string &name)
{
    // Look up the password entry
    if ((_pwd = getpwnam(name.c_str())) == 0)
	throw Exception("username not found");    
}
