/* ------------------------------------------------------------------------
 * $Id: DocumentHandler.hh,v 1.1 2001/08/16 11:32:21 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * This C++ SAX implementation (Simple API for XML) is derived from
 * David Megginson's original Java SAX that can be found on 
 * http://www.megginson.com/SAX/.
 * ------------------------------------------------------------------------
 * File created 2001-08-13 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------ 
 */

#ifndef _SAXDocumentHandler_hh_
#define _SAXDocumentHandler_hh_

// -- System Includes
#include <string>

// -- Local Includes
//#include "Celsius/SAX/AttributeList.hh"

namespace SAX {

    // -- Forward Declarations
    class Locator;
    class AttributeList;

    // -- Class Declarations
    
    /**
     * Receive notification of general document events. 
     **/
    class DocumentHandler {
    public:
	
	/**
	 * Constructor.
	 **/
	DocumentHandler() { }
	
	/**
	 * Destructor.
	 **/
	virtual ~DocumentHandler() { }

	/**
	 * Receive an object for locating the origin of SAX document
	 * events.
	 *
	 * @param object that can return the location of any SAX
	 *        document event.
	 **/
	virtual void setDocumentLocator(const Locator &locator) = 0;

	/**
	 * Receive notification of the beginning of a document. The
	 * SAX parser will invoke this method only once, before any
	 * other methods in this interface or in DTDHandler (except
	 * for setDocumentLocator).
	 **/
	virtual void startDocument() = 0;

	/**
	 * Receive notification of the end of a document.  The SAX
	 * parser will invoke this method only once, and it will be
	 * the last method invoked during the parse. The parser shall
	 * not invoke this method until it has either abandoned
	 * parsing (because of an unrecoverable error) or reached the
	 * end of input.
	 **/
	virtual void endDocument() = 0;

	/**
	 * Receive notification of the beginning of an element. The
	 * parser will invoke this method at the beginning of every
	 * element in the XML document; there will be a corresponding
	 * endElement() event for every startElement() event (even
	 * when the element is empty). All of the element's content
	 * will be reported, in order, before the corresponding
	 * endElement() event.
	 * 
	 * @param name element type name.
	 * @param atts attributes attached to the element, if any.
	 **/
	virtual void startElement(const std::string &name,
				  const AttributeList &atts) = 0;

	/**
	 * Receive notification of the end of an element. The SAX
	 * parser will invoke this method at the end of every element
	 * in the XML document; there will be a corresponding
	 * startElement() event for every endElement() event (even
	 * when the element is empty).
	 *
	 * @param name element type name.
	 **/
	virtual void endElement(const std::string &name) = 0;

	/**
	 * Receive notification of character data. The parser will
	 * call this method to report each chunk of character
	 * data. SAX parsers may return all contiguous character data
	 * in a single chunk, or they may split it into several
	 * chunks; however, all of the characters in any single event
	 * must come from the same external entity, so that the
	 * Locator provides useful information. Note that some parsers
	 * will report whitespace using the ignorableWhitespace()
	 * method rather than this one (validating parsers must do
	 * so).
	 *
	 * @param ch characters from the XML document.
	 **/
	virtual void characters(const std::string &ch) = 0;

	/**
	 * Receive notification of ignorable whitespace in element
	 * content. Validating parsers must use this method to report
	 * each chunk of ignorable whitespace (see the W3C XML 1.0
	 * recommendation, section 2.10): non-validating parsers may
	 * also use this method if they are capable of parsing and
	 * using content models.
	 *
	 * @param ch characters from the XML document.
	 **/
	virtual void ignorableWhitespace(const std::string &ch) = 0;

	/**
	 * Receive notification of a processing instruction. The
	 * parser will invoke this method once for each processing
	 * instruction found: note that processing instructions may
	 * occur before or after the main document element.
	 *
	 * @param target processing instruction target.
	 * @param data processing instruction data, or null if
	 *             none was supplied.
	 **/
	virtual void processingInstruction(const std::string &target,
					   const std::string &data) = 0;
    };
    
};

#endif /* DocumentHandler.hh */
