/* ------------------------------------------------------------------------
 * $Id: client.cc,v 1.17 2001/08/28 13:18:48 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-07-24 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- System Includes
#include <iostream>
#include <stdlib.h>
#include <unistd.h>
#include <vector>

// -- 3Dwm Includes
#include <Nobel++/Nobel.hh>
#include <Nobel++/ImageLoader.hh>
#include <Nobel/Shape.hh>
#include <Nobel/Image.hh>
#include <Nobel/Solid.hh>
#include <Nobel/SolidKit.hh>
#include <Nobel/SolidContainer.hh>
#include <Nobel/NodeKit.hh>
#include <Nobel/Transform.hh>
#include <Nobel/Appearance.hh>
#include <Nobel/GeometryKit.hh>
#include <Nobel/PrimitiveKit.hh>
#include <Nobel/LineGeometry.hh>
#include <Nobel/TriangleGeometry.hh>

using namespace Nobel;

// -- Local Function Prototypes

static void buildCSGHierarchy(Node_ptr root, NodeKit_ptr node_kit,
			      GeometryKit_ptr geo_kit, SolidKit_ptr solid_kit,
			      PrimitiveKit_ptr prim_kit);

// -- Code Segment

int main(int argc, char *argv[]) {
    
    try {

	// Initialize the connection
	Nobelxx::Client client("CSG Client", argc, argv);
	
	// Resolve the necessary kits
	NodeKit_var node_kit =
	    client.resolve<NodeKit>(Nobelxx::name<NodeKit>());
	GeometryKit_var geo_kit =
	    client.resolve<GeometryKit>(Nobelxx::name<GeometryKit>());
	SolidKit_var solid_kit = 
	    client.resolve<SolidKit>(Nobelxx::name<SolidKit>());
	PrimitiveKit_var prim_kit = 
	    client.resolve<PrimitiveKit>(Nobelxx::name<PrimitiveKit>());
	
	// And here's the scene graph root (local to the client)
	Node_var root = client.root();
	
	// Build the CSG hierarchy in the server
	buildCSGHierarchy(root, node_kit, geo_kit, solid_kit, prim_kit);
    }
    catch (const CORBA::Exception &e) {

	// The ORB threw an exception
	std::cerr << "Uncaught CORBA exception: " << e << std::endl;
	return EXIT_FAILURE;
    }
    catch (...) {
	
	// Another exception was raised
	std::cerr << "Exception thrown. Exiting." << std::endl;
	return EXIT_FAILURE;
    }
    
    return EXIT_SUCCESS;
}

void buildCSGHierarchy(Node_ptr root, NodeKit_ptr node_kit,
		       GeometryKit_ptr geo_kit, SolidKit_ptr solid_kit,
		       PrimitiveKit_ptr prim_kit)
{
    Nobelxx::ImageLoader image_loader;
    
    // Create the CSG node
    SolidContainer_var node = solid_kit->createContainer();

    // Create appearances
    Appearance_var app1 = geo_kit->createAppearance();
    Appearance_var app2 = geo_kit->createAppearance();

    /*
    Texture_var tex1 = geo_kit->createTexture();
    Texture_var tex2 = geo_kit->createTexture();
    Texture_var tex3 = geo_kit->createTexture();
    
    if (image_loader.loadPNG("texture-mosaic.png") == false)
	std::cerr << "Failed to load texture!" << std::endl;
    tex1->loadRaw(image_loader.rawData(), image_loader.width(),
		  image_loader.height(), image_loader.pixelType());
    
    if (image_loader.loadPNG("texture-steel2.png") == false)
	std::cerr << "Failed to load texture!" << std::endl;
    tex2->loadRaw(image_loader.rawData(), image_loader.width(),
		  image_loader.height(), image_loader.pixelType());

    if (image_loader.loadPNG("texture-steel3.png") == false)
	std::cerr << "Failed to load texture!" << std::endl;
    tex3->loadRaw(image_loader.rawData(), image_loader.width(),
		  image_loader.height(), image_loader.pixelType());

    app1->setTexture(tex1);
    app2->setTexture(tex2);
    app3->setTexture(tex3);
    */
    MaterialAttributes material;

    material.diffuse = Nobelxx::Color(0, 1, 0);
    app1->material(material);
    
    material.diffuse = Nobelxx::Color(0, 0, 1);
    app2->material(material);

    Solid::Appearance_var s_app1 = solid_kit->createAppearance(app1);
    Solid::Appearance_var s_app2 = solid_kit->createAppearance(app2);
    
    //TriangleGeometry_var cube = box(geo_kit);
    //Solid::Geometry_var geo = solid_kit->createGeometry(cube);
    Primitive_var cube = prim_kit->createCuboid();
    //Primitive_var cube = prim_kit->createCone(16);
    //Primitive_var cube = prim_kit->createCylinder(16);
    Primitive_var sphere = prim_kit->createSphere(16, 16);
    //Primitive_var cube = prim_kit->createPlane();
    Solid::Primitive_var prim1 = solid_kit->createPrimitive(cube);
    Solid::Primitive_var prim2 = solid_kit->createPrimitive(sphere);
    
    s_app1->body(prim1);
    s_app2->body(prim2);
    
    Solid::Transform_var t1 = solid_kit->createTransform(s_app1);
    Solid::Transform_var t2 = solid_kit->createTransform(s_app2);

    t1->scale(Nobelxx::Vertex3D(10.0, 10.0, 10.0));

    t2->scale(Nobelxx::Vertex3D(7.5, 7.5, 7.5));
    
    /*
    Solid::Binary_var base2 = solid_kit->createIntersection(base, t1);
    Solid::Binary_var base3 = solid_kit->createIntersection(base2, t2);
    Solid::Binary_var final = solid_kit->createIntersection(base3, t3);
    Solid::Binary_var base2 = solid_kit->createUnion(base, t1);
    Solid::Binary_var base3 = solid_kit->createUnion(base2, t2);
    Solid::Binary_var final = solid_kit->createUnion(base3, t3);
    */
    Solid::Binary_var final = solid_kit->createIntersection(t1, t2);
    node->setTree(final);

    // Evaluate the node to get some output
    node->evaluate();

    // Add the node to the server scene graph
    root->insert(node);    
}
