/**************************************************************
*   
*   Creation Date: <1998-10-31 03:11:06 samuel>
*   Time-stamp: <2000/11/05 19:43:52 samuel>
*   
*	<mmu_mappings.h>
*	
*	Mappings mac physical <-> linux virtual
*   
*   Copyright (C) 1998, 1999, 2000 Samuel Rydh
*  
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation;
*   
**************************************************************/

#ifndef _H_MMU_MAPPINGS
#define _H_MMU_MAPPINGS

struct mmu_mapping {
	ulong	mbase;		/* mac physical base */
	char	*lvbase;	/* linux virtual base */
	size_t	size;		/* size (in bytes) */
	int	flags;		/* MAPPING_xxx */

	int	id;		/* set to zero, returned by the kerrnel module */
};

/* mmu_mapping.flags field */

#define MAPPING_RW			1	/* read/write access */
#define MAPPING_PHYSICAL		2	/* lvptr is a PHYSICAL address */
#define MAPPING_SCRATCH			4	/* use a "don't care" page */
#define MAPPING_FORCE_CACHE		8	/* force cache on */
#define MAPPING_FB_ACCEL		16	/* track changes (for the X-fb) */
#define MAPPING_FB			32	/* framebuffer (ea assumed to be constant) */
#define MAPPING_DBAT			64	/* may use a dbat register */
#define MAPPING_MACOS_CONTROLS_CACHE	128	/* allow MacOS to control the WIM bits */ 

#endif   /* _H_MMU_MAPPINGS */


