/**************************************************************
*   
*   Creation Date: <97/06/24 22:25:04 samuel>
*   Time-stamp: <2001/06/24 00:06:20 samuel>
*   
*	<mac_registers.h>
*	
*
*   
*   Copyright (C) 1997, 1999, 2000, 2001 Samuel Rydh
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation;
*
**************************************************************/

#ifndef _MAC_REGISTERS_H
#define _MAC_REGISTERS_H

#ifndef __ASSEMBLY__

#ifndef __KERNEL__
#include "processor.h"
#endif

/* WARNING: <asm/processor.h> contains bogus definitions of the following sprs: 
   TBRU, TBRL, TBWU, TBWL, SPRN_TBRL, SPRN_TBRU, SPRN_TBWU, SPRN_TBWL
*/

/* To allocate memory for 1024 SPRs might be considered a waste of 
 * of resources, though it makes the code slightly more effective...
 */
#define NUM_SPRS	1024
#define	S_DSISR		DSISR	/* Source Instruction Service Register */
#define S_DAR		DAR	/* Data Address Register */
#define S_RTCU_R    	4	/* 601 RTC Upper/Lower (Reading) */
#define S_RTCL_R       	5
#define S_RTCU_W    	20	/* 601 RTC Upper/Lower (Writing) */
#define S_RTCL_W       	21
#define S_TBRU		0x10D	/* Time base Upper/Lower (Reading) */
#define S_TBRL		0x11C
#define S_TBWU		0x11D	/* Time base Upper/Lower (Writing) */
#define S_TBWL		0x11C
#define S_DEC		DEC	/* Decrementer Register */
#define S_SDR1		SDR1	/* Table Search Description Register */
#define S_SRR0		SRR0	/* Save and Restore Register 0 */
#define S_SRR1		SRR1	/* Save and Restore Register 1 */
#define S_SPRG0		SPRG0	/* SPR General 0 */
#define S_SPRG1		SPRG1	/* SPR General 1 */
#define S_SPRG2		SPRG2	/* SPR General 2 */
#define S_SPRG3		SPRG3	/* SPR General 3 */
#define S_EAR		EAR	/* External Access Register */
#define S_PVR		PVR	/* Processor Version Register */
#define S_IBAT0U	IBAT0U	/* BAT0 - upper, do NOT change order! */
#define S_IBAT0L	IBAT0L	/* BAT0 - lower  */
#define S_IBAT1U	IBAT1U	/* BAT1 - upper  */
#define S_IBAT1L	IBAT1L	/* BAT1 - lower  */
#define S_IBAT2U	IBAT2U	/* BAT2 - upper  */
#define S_IBAT2L	IBAT2L	/* BAT2 - lower  */
#define S_IBAT3U	IBAT3U	/* BAT3 - upper  */
#define S_IBAT3L	IBAT3L	/* BAT3 - lower  */
#define S_DBAT0U	DBAT0U	/* DBAT0 - upper, do NOT change order! */
#define S_DBAT0L	DBAT0L	/* DBAT0 - lower  */
#define S_DBAT1U	DBAT1U	/* DBAT1 - upper  */
#define S_DBAT1L	DBAT1L	/* DBAT1 - lower  */
#define S_DBAT2U	DBAT2U	/* DBAT2 - upper  */
#define S_DBAT2L	DBAT2L	/* DBAT2 - lower  */
#define S_DBAT3U	DBAT3U	/* DBAT3 - upper  */
#define S_DBAT3L	DBAT3L	/* DBAT3 - lower  */

#define S_MMCR0		952	/* 604e */
#define S_MMCR1		956	/* 604e */
#define S_PMC1		953	/* 604e */
#define S_PMC2		954	/* 604e */
#define S_PMC3		957	/* 604e */
#define S_PMC4		958	/* 604e */
#define S_SIA		955	/* 604e */
#define S_SDA		959	/* 604e */
#define S_HID0		HID0	/* 601, 604 */
#define S_HID1		1009	/* 601, 604 */
#define S_HID2		1010	/* 601, 604 IABR */
#define S_HID5   	1013	/* 601 DABR */
#define S_HID15		1023	/* HID15 (PIR, processor identification reg) */ 

typedef struct {
	unsigned long	h,l;
} fpu_register;

#define NUM_DEBUG_REGS		10

typedef struct {
	unsigned long	words[4];
} altivec_reg_t;

typedef struct mac_regs {
	/* Keep this 4-word aligned */
	altivec_reg_t	vec[32];		/* AltiVec vector registers */

	/* These things must be quad-word aligned! */
	unsigned long	vscr_pad[3];		/* vscr_pad...vscr must be continuous */
	unsigned long	vscr;			/* AltiVec status control register */
	unsigned long	pad[4];

	/* Keep this cache-block aligned (typcically 8 words) */
	unsigned long	cr;			/* Condition register */
	unsigned long	link;			/* Link register */
	unsigned long	flag_bits;		/* Various flags (fbXXXXX) */
	unsigned long	ctr;			/* Count register */
	unsigned long 	gpr[32];

	/* These things must be double-word aligned! */
	fpu_register	fpr[32];		/* FPU registers (64 bits) */
	unsigned long	fpscr_pad;		/* fpscr_pad...fpscr must be continuous */
	unsigned long	fpscr;			/* fp. status and control register*/
	unsigned long	emulator_fpscr_pad;	/* must be continuous with... */
	unsigned long	emulator_fpscr;		/* ...emulator_fpscr */
	unsigned long	fpu_state;		/* FPU_STATE_xxx (see below) */
	unsigned long	filler[3];		/* cache-block aligner... */

	unsigned long	nip;			/* Instruction pointer */
	unsigned long	msr;			/* Machine state register (virtual) */
	unsigned long	_msr;			/* MSR - physically used in emulated process */
	unsigned long	xer;			/* Integer exception register */
	unsigned long	mq;			/* 601 only */

	/* supervisor mode registers */
	unsigned long	spr[NUM_SPRS];		/* special purpose registers  */
	unsigned long	segr[16];		/* segment registers */

	/* interrupts */
	int		interrupt;		/* set if the kernel should return to the emulator */
	int		irq;			/* external interrupt (masked by MSR_EE) */

	/* timer */
	ulong		dec_stamp;		/* xDEC = dec_stamp - tbl */
	ulong		timer_stamp;		/* TIMER = dec_stamp - tbl */

	/* RVEC parameters */
	ulong		rvec_param[3];		/* Used in kernel C-mode */

	/* misc */
	unsigned long	inst_opcode;		/* opcode of instruction */
	int   		processor;		/* processor to emulate, 1=601, 4=604 */
	int		altivec_used;		/* useful for altivec detection */
	int		no_altivec;		/* Don't use altivec (e.g. no kernel support) */

	/* DEBUG */
	unsigned long   debug[NUM_DEBUG_REGS];
	unsigned long	debug_scr1;		/* dbg scratch register */
	unsigned long	debug_scr2;		/* dbg scratch register */
	unsigned long	debug_trace;		/* dbg trace register */
	unsigned long	dbg_trace_space[256];
	unsigned long	dbg_last_rvec;		/* useful for tracing segfaults etc. */
	unsigned long	dbg_last_osi;
	unsigned long	dbg_in_mac_mode;

	unsigned long	kernel_dbg_stop;	/* stop emulation flag */
} mac_regs_t;

/* --- some handy macros, should proably go in some other headerfile ---- */

#define OPCODE(n)		( ((ulong)(n)) >> 26 )
#define OPCODE_EXT(n)		( (((ulong)(n)) >> 1) & 0x3ff )
#define SW_OP(op,op_ext)	( ((op)<<10) + op_ext )

#define	BIT(n)			(1U<<(31-(n)))	/* bit 0 is MSB */

#define	B1(n)			( (((ulong)(n)) >> 21) & 0x1f )
#define	B2(n)			( (((ulong)(n)) >> 16) & 0x1f )
#define	B3(n)			( (((ulong)(n)) >> 11) & 0x1f )

#define BD(n)	((ulong)((n) & 0x7fff) + (((n) & 0x8000) ? (ulong)0xffff8000 : 0))

#ifndef __KERNEL__
extern mac_regs_t *mregs;
#endif
#endif /* __ASSEMBLY__ */

/* mregs->fpu_state, included from assembly */
/* Note: FPU_STATE_IN_USE is only seen from the kernel code */
#define FPU_STATE_HALF_SAVED	0	/* fpscr & fr0-fr13 saved */
#define FPU_STATE_DIRTY		1	/* fpscr & fr13 saved */
#define FPU_STATE_IN_USE	2	/* the FPU is fully loaded (and we may turn on MSR_FP) */
#define FPU_STATE_SAVED		3	/* everything is saved to mregs */

/* flag_bits (loaded into cr5-7). */
/* TOUCH THESE *ONLY* FROM TO MAIN THREAD! */

#define FBIT_MolDecLoaded	31	/* (U) cr7 */
#define FBIT_DecSeenZero	30
#define FBIT_CheckFlags		29	/* (U) Certain flags need to be examined */
#define   FBIT_MsrModified	27	/* (U) cr6 */
#define   FBIT_RecalcDecInt	26	/* (U) */
#define   FBIT_Exception	25	/* (U) cause an exception */
#define FBIT_DecINT		23	/* (U) cr5 */
#define FBIT_TimerINT		22	/* (U) */

#define fb_MolDecLoaded		BIT( FBIT_MolDecLoaded )
#define fb_DecSeenZero		BIT( FBIT_DecSeenZero )
#define fb_CheckFlags		BIT( FBIT_CheckFlags )
#define   fb_MsrModified	BIT( FBIT_MsrModified )
#define   fb_RecalcDecInt	BIT( FBIT_RecalcDecInt )
#define   fb_Exception		BIT( FBIT_Exception )
#define fb_DecINT		BIT( FBIT_DecINT )
#define fb_TimerINT		BIT( FBIT_TimerINT )


#endif /* _MAC_REGISTERS_H */
