/*
 * This program is used to generate definitions needed by
 * some assembly functions.
 *
 * We use the technique used in the OSF Mach kernel code:
 * generate asm statements containing #defines,
 * compile this file to assembler, and then extract the
 * #defines from the assembly-language output.
 */

#ifdef KERNEL
#include "compat.h"
#include "kernel_vars.h"
#include "mmu.h"
#include "processor.h"
#else
#include "mol_config.h"
#include <stddef.h>
#include "mac_registers.h"
#endif

#define DEFINE(sym, val) \
	asm volatile("\n#define\t" #sym "\t%0" : : "i" (val))

#define K_DEF(sym, val ) \
	DEFINE(sym, offsetof(kernel_vars_t, val ))

#define ST_DEF(sym, val ) \
	DEFINE(sym, offsetof(session_table_t, val ))

#define M_DEF(sym, val ) \
	DEFINE(sym, XOFFS + offsetof(mac_regs_t, val ))

#define IO_DEF(sym, val) \
	DEFINE(sym, offsetof(struct io_page, val ))

int main( void )
{
#ifdef KERNEL
	#define XOFFS	offsetof(kernel_vars_t, mregs)
#else
	#define XOFFS	0
#endif
	/* --- mac_regs offsets --- */

	M_DEF( xVEC_BASE, vec[0] );
	M_DEF( xVEC0, vec[0] );
	M_DEF( xVEC1, vec[1] );
	M_DEF( xVEC2, vec[2] );
	M_DEF( xVSCR, vscr );
	M_DEF( xVRSAVE, spr[SPRN_VRSAVE] );

	M_DEF( xGPR_BASE, gpr[0] );
	M_DEF( xGPR0, gpr[0] );
	M_DEF( xGPR1, gpr[1] );
	M_DEF( xGPR2, gpr[2] );
	M_DEF( xGPR3, gpr[3] );
	M_DEF( xGPR4, gpr[4] );
	M_DEF( xGPR5, gpr[5] );
	M_DEF( xGPR6, gpr[6] );
	M_DEF( xGPR7, gpr[7] );
	M_DEF( xGPR8, gpr[8] );
	M_DEF( xGPR9, gpr[9] );
	M_DEF( xGPR10, gpr[10] );
	M_DEF( xGPR11, gpr[11] );
	M_DEF( xGPR12, gpr[12] );
	M_DEF( xGPR13, gpr[13] );
	M_DEF( xGPR14, gpr[14] );
	M_DEF( xGPR15, gpr[15] );
	M_DEF( xGPR16, gpr[16] );
	M_DEF( xGPR17, gpr[17] );
	M_DEF( xGPR18, gpr[18] );
	M_DEF( xGPR19, gpr[19] );
	M_DEF( xGPR20, gpr[20] );
	M_DEF( xGPR21, gpr[21] );
	M_DEF( xGPR22, gpr[22] );
	M_DEF( xGPR23, gpr[23] );
	M_DEF( xGPR24, gpr[24] );
	M_DEF( xGPR25, gpr[25] );
	M_DEF( xGPR26, gpr[26] );
	M_DEF( xGPR27, gpr[27] );
	M_DEF( xGPR28, gpr[28] );
	M_DEF( xGPR29, gpr[29] );
	M_DEF( xGPR30, gpr[30] );
	M_DEF( xGPR31, gpr[31] );

	M_DEF( xNIP, nip);
	M_DEF( x_MSR, _msr);
	M_DEF( xCR, cr);
	M_DEF( xFPR_BASE, fpr[0]);
	M_DEF( xFPR13, fpr[13]);
	M_DEF( xFPSCR, fpscr );
	M_DEF( xEMULATOR_FPSCR, emulator_fpscr );
	M_DEF( xFPU_STATE, fpu_state );

	M_DEF( xLINK, link);
	M_DEF( xXER, xer);
	M_DEF( xCTR, ctr);
	M_DEF( xFLAG_BITS, flag_bits );
//	M_DEF( xDEC, spr[S_DEC]);
	M_DEF( xDEC_STAMP, dec_stamp);
	M_DEF( xTIMER_STAMP, timer_stamp);
	M_DEF( xMSR, msr);	
	M_DEF( xMQ, mq);
	M_DEF( xSPR_BASE, spr[0]);

	M_DEF( xSRR0, spr[S_SRR0]);
	M_DEF( xSRR1, spr[S_SRR1]);

	M_DEF( xSEGR_BASE, segr[0]);
	M_DEF( xIBAT_BASE, spr[S_IBAT0U] );
	M_DEF( xSDR1, spr[S_SDR1] );

	M_DEF( xINST_OPCODE, inst_opcode );
	M_DEF( xALTIVEC_USED, altivec_used );
	M_DEF( xNO_ALTIVEC, no_altivec );

	M_DEF( xINTERRUPT, interrupt );
	M_DEF( xIRQ, irq );

	M_DEF( xRVEC_PARAM0, rvec_param[0] );
	M_DEF( xRVEC_PARAM1, rvec_param[1] );
	M_DEF( xRVEC_PARAM2, rvec_param[2] );

	M_DEF( xDEBUG0, debug[0] );
	M_DEF( xDEBUG1, debug[1] );
	M_DEF( xDEBUG2, debug[2] );
	M_DEF( xDEBUG3, debug[3] );
	M_DEF( xDEBUG4, debug[4] );
	M_DEF( xDEBUG5, debug[5] );
	M_DEF( xDEBUG6, debug[6] );
	M_DEF( xDEBUG7, debug[7] );
	M_DEF( xDEBUG8, debug[8] );
	M_DEF( xDEBUG9, debug[9] );

	M_DEF( xDEBUG_SCR1, debug_scr1 );
	M_DEF( xDEBUG_SCR2, debug_scr2 );
	M_DEF( xDEBUG_TRACE, debug_trace );
	M_DEF( xDBG_TRACE_SPACE, dbg_trace_space[0] );
	M_DEF( xDBG_LAST_RVEC, dbg_last_rvec );
	M_DEF( xDBG_IN_MAC_MODE, dbg_in_mac_mode );

	M_DEF( xKERNEL_DBG_STOP, kernel_dbg_stop );

#ifdef KERNEL
	DEFINE(SIZE_OF_KERNEL_VARS, sizeof( kernel_vars_t ));

	ST_DEF( ST_ENTRY_MAGIC, entry_magic );
	ST_DEF( ST_KVARS_PH, kvars_ph );

	K_DEF( K_KERNEL_VARS, kernel_vars );
	K_DEF( K_BREAK_FLAGS, break_flags );

	/* MMU */
	K_DEF( K_CUR_SR_BASE, mmu.cur_sr_base );
	K_DEF( K_SR_DATA, mmu.sr_data );
	K_DEF( K_SR_INST, mmu.sr_inst );
	K_DEF( K_ILLEGAL_SR, mmu.illegal_sr );

	K_DEF( K_UNMAPPED_SR_BASE, mmu.unmapped_sr[0] );
	K_DEF( K_USER_SR_BASE, mmu.user_sr[0] );
	K_DEF( K_SV_SR_BASE, mmu.sv_sr[0] );
	K_DEF( K_SPLIT_SR_BASE, mmu.split_sr[0] );

	K_DEF( K_IBAT0U_SAVE, _bp.ibat_save[0].word[0] );
	K_DEF( K_IBAT0L_SAVE, _bp.ibat_save[0].word[1] );
	K_DEF( K_IBAT1U_SAVE, _bp.ibat_save[1].word[0] );
	K_DEF( K_IBAT1L_SAVE, _bp.ibat_save[1].word[1] );
	K_DEF( K_IBAT2U_SAVE, _bp.ibat_save[2].word[0] );
	K_DEF( K_IBAT2L_SAVE, _bp.ibat_save[2].word[1] );
	K_DEF( K_IBAT3U_SAVE, _bp.ibat_save[3].word[0] );
	K_DEF( K_IBAT3L_SAVE, _bp.ibat_save[3].word[1] );

	K_DEF( K_DBAT0U_SAVE, _bp.dbat_save[0].word[0] );
	K_DEF( K_DBAT0L_SAVE, _bp.dbat_save[0].word[1] );
	K_DEF( K_DBAT1U_SAVE, _bp.dbat_save[1].word[0] );
	K_DEF( K_DBAT1L_SAVE, _bp.dbat_save[1].word[1] );
	K_DEF( K_DBAT2U_SAVE, _bp.dbat_save[2].word[0] );
	K_DEF( K_DBAT2L_SAVE, _bp.dbat_save[2].word[1] );
	K_DEF( K_DBAT3U_SAVE, _bp.dbat_save[3].word[0] );
	K_DEF( K_DBAT3L_SAVE, _bp.dbat_save[3].word[1] );

	K_DEF( K_DBAT0U, mmu.dbat0.word[0] );
	K_DEF( K_DBAT0L, mmu.dbat0.word[1] );
	K_DEF( K_TRANSL_DBAT0U, mmu.transl_dbat0.word[0] );
	K_DEF( K_TRANSL_DBAT0L, mmu.transl_dbat0.word[1] );

	K_DEF( K_SPLITMODE_ALGORITHM, mmu.splitmode_algorithm );

	K_DEF( K_TLBHASH_SR, mmu.pthash_sr );
	K_DEF( K_TLBHASH_BASE_EA, mmu.pthash_ea_base );
	K_DEF( K_HASH_MASK, mmu.hash_mask );

	/* private to base.h */
	K_DEF( K_DEC_STAMP, _bp.dec_stamp );
	K_DEF( K_INT_STAMP, _bp.int_stamp);

	K_DEF( K_TMP_SCRATCH0, _bp.tmp_scratch[0] );
	K_DEF( K_TMP_SCRATCH1, _bp.tmp_scratch[1] );
	K_DEF( K_TMP_SCRATCH2, _bp.tmp_scratch[2] );
	K_DEF( K_TMP_SCRATCH3, _bp.tmp_scratch[3] );

	K_DEF( K_IN_SPLITMODE, _bp.in_splitmode );
	K_DEF( K_PREPARE_SPLITMODE, _bp.prepare_splitmode );
	K_DEF( K_SPLIT_NIP_SEGMENT, _bp.split_nip_segment );

	K_DEF( K_RELOAD_SR, _bp.reload_sr );

	K_DEF( K_SPR_HOOKS, _bp.spr_hooks );

	/* private to emulation.S */
	K_DEF( K_MSR_SR_TABLE, _bp.msr_sr_table[0] );

	/* io_page_t type */
	IO_DEF( IOP_MAGIC, magic );
	IO_DEF( IOP_MAGIC2, magic2 );
	IO_DEF( IOP_MPHYS, mphys );
	IO_DEF( IOP_ME_PHYS, me_phys );
	IO_DEF( IOP_NEXT, next );
	IO_DEF( IOP_USR_DATA, usr_data );

	/****** New Low-level assembly implementation ***********/

	K_DEF( K_EMULATOR_STACK, _bp.emulator_stack );
	K_DEF( K_EMULATOR_TOC, _bp.emulator_toc );
	K_DEF( K_EMULATOR_NIP, _bp.emulator_nip );
	K_DEF( K_EMULATOR_MSR, _bp.emulator_msr );
	K_DEF( K_EMULATOR_SPRG2, _bp.emulator_sprg2 );
	K_DEF( K_EMULATOR_SPRG3, _bp.emulator_sprg3 );
	K_DEF( K_EMULATOR_KCALL_NIP, _bp.emulator_kcall_nip );

	K_DEF( K_EMULATOR_SR, mmu.emulator_sr );
#endif
	return 0;
}
