/* 
 *   Creation Date: <1999/09/25 17:25:30 samuel>
 *   Time-stamp: <2001/04/21 16:55:24 samuel>
 *   
 *	<reloc.h>
 *	
 *	Definitions used to move criticalal low-level parts
 *	of the code to continuous physical memory.
 *   
 *   Copyright (C) 1999, 2000, 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_RELOC
#define _H_RELOC

/* Special 'action symbols' are used to dynamically modify the code. */

#define NO_ACTION			0
#define  ACTION_KVARS_TABLE		1
#define  ACTION_KVARS_TABLE_VIRT	2

#define FIRST_RELOC_ACTION		3
#define   ACTION_LI_PHYS		3	/* dest_reg, addr */
#define LAST_RELOC_ACTION		3

#define FIRST_HOOK_ACTION		5
#define   ACTION_RELOC_HOOK		6	/* trigger, size, vret_action#, vret_offs */
#define   ACTION_VRET			7
#define   ACTION_HOOK_FUNCTION		8
#define   ACTION_FRET			9
#define LAST_HOOK_ACTION		9

#define MAX_ACTION			15	/* used to loop the actions */

/* Function hooks */
#define FHOOK_FLUSH_HASH_PAGE	1


#ifdef ACTION_SYM_GREPPING
#define ACTION_SYMBOL( sym_name, action ) \
	ACTION_SYM_START,##sym_name,##action,ACTION_SYM_END
#define GLOBAL_SYMBOL( sym_name ) \
	GLOBAL_SYM_START,##sym_name,GLOBAL_SYM_END
#else
#define ACTION_SYMBOL( sym_name, dummy2 ) \
sym_name:
#define GLOBAL_SYMBOL( sym_name ) \
GLOBL(sym_name)
#endif


#ifndef __ASSEMBLY__

extern int reloc_phys_offs;
extern int reloc_virt_offs;

#define reloc_ptr( v )  ((ulong)(v) + (ulong)reloc_virt_offs)

enum {
	R_PPC_ADDR16_LO = 1,
	R_PPC_ADDR16_HA,
	R_PPC_ADDR16_HI,
	R_PPC_ADDR32,
	/* unsupported */
	R_PPC_REL24,
	R_PPC_REL14
};

typedef struct reloc_table {
	unsigned long 	inst_offs;
	int 		action;
	int		rtype;
	unsigned long	offs;
} reloc_table_t, reloc_table_entry_t;
#endif

#endif   /* _H_RELOC */
