/* 
 *   Creation Date: <1999/02/18 22:36:58 samuel>
 *   Time-stamp: <2001/06/24 17:37:05 samuel>
 *   
 *	<timer.h>
 *	
 *	Timer handling
 *   
 *   Copyright (C) 1999, 2000, 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_TIMER
#define _H_TIMER

#include <sys/types.h>
#include <sys/time.h>


/************************************************************************/
/*	Initialize / mainloop-interface					*/
/************************************************************************/

extern void	timer_init( void );
extern void	timer_cleanup( void );

extern void	_timer_expired( void );		/* private */

/* exports for mainloop.c */

extern void	doze( void );
extern void	abort_doze( void );

static inline void do_timer_stuff( int has_expired ) {
	extern int __recalc_timer;
	if( __recalc_timer || has_expired )
		_timer_expired();
}

static inline void clear_abort_doze( void ) {
	extern volatile int __abort_doze;
	__abort_doze = 0;
}

/************************************************************************/
/*      Client interface						*/
/************************************************************************/

/* mticks are measured in DEC units (machine dependent) */

typedef void (*timer_fp)( ulong id, void *usr );

extern int	settimer_abs_mticks( ullong mt, timer_fp tproc, void *usr, int activate );
static int	settimer_usecs( ulong usecs, timer_fp tproc, void *usr );
extern void	cancel_timer( ulong id );

extern int	new_ptimer( timer_fp tproc, void *usr );
extern void 	free_ptimer( int id );
extern int	restart_ptimer( int id, ulong uperiod, int allow_skip );
extern int	resume_ptimer( int id );


/************************************************************************/
/*      Mticks util							*/
/************************************************************************/

extern ullong get_mticks_( void );	/* in misc.S */

static inline ulong get_tbl( void ){
	ulong ret;
	asm volatile("mftbl %0" : "=r" (ret) : );
	return ret;
}


/* private */
extern ulong	__ticks_per_usec_num;
extern ulong	__ticks_per_usec_den;

static inline ullong usecs_to_mticks_( ulong usecs ) {
	return (ullong)__ticks_per_usec_num * usecs / __ticks_per_usec_den;
}

static inline ulong mticks_to_usecs_( ullong mt ) {
	return (mt * __ticks_per_usec_den) / __ticks_per_usec_num;
}

static inline int settimer_usecs( ulong usecs, timer_fp tproc, void *usr ) {
	return settimer_abs_mticks( usecs_to_mticks_(usecs)+get_mticks_(), tproc, usr, 1 );
}

static inline int settimer_mticks_( ullong mt, timer_fp tproc, void *usr ) {
	return settimer_abs_mticks( get_mticks_() + mt, tproc, usr, 1 );
}

#endif   /* _H_TIMER */
