/* 
 *   Creation Date: <2001/06/16 18:43:50 samuel>
 *   Time-stamp: <2001/06/24 17:41:07 samuel>
 *   
 *	<elf.c>
 *	
 *	Loads and run a ELF-file
 *   
 *   Copyright (C) 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#include "mol_config.h"
#include <sys/param.h>
#include "booter.h"
#include "elfload.h"
#include "memory.h"
#include "mac_registers.h"
#include "res_manager.h"
#include "video.h"

static void elf_startup( void );
static void elf_cleanup( void );

void
elf_booter_init( void )
{
	gPE.booter_startup = elf_startup;
	gPE.booter_cleanup = elf_cleanup;
}

static void
elf_startup( void )
{
	Elf32_Ehdr	ehdr;
	Elf32_Phdr	*phdr;
	fs_ops_t 	*fs = fs_native_open();
	char		*name;
	file_desc_t 	fd;
	int		i;
	
	if( !(name=get_str_res("elf_image")) ){
		printm("No ELF image is specified\n");
		exit(1);
	}
	if( !(fd=fs_open_path(fs, name) ) ) {
		printm("Could not open '%s'\n", name);
		exit(1);
	}
	if( !is_elf32( fs,fd, 0) ){
		printm("/tmp/vmlinux is not an ELF image\n");
		exit(1);
	}
	if( !(phdr = elf32_readhdrs( fs, fd, 0, &ehdr )) ){
		printm("elf32_readhdrs failed\n");
		exit(1);
	}
	for( i=0; i<ehdr.e_phnum; i++ ) {
		size_t s = MIN( phdr[i].p_filesz, phdr[i].p_memsz );
		char *addr;
		/*printm("filesz: %08X memsz: %08X p_offset: %08X p_vaddr %08X\n", 
		  phdr[i].p_filesz, phdr[i].p_memsz, phdr[i].p_offset, phdr[i].p_vaddr ); */

		/* Linux kernel hack */
		if( phdr[i].p_paddr == 0xc0000000 )
			phdr[i].p_paddr = 0;

		if( verify_lvrange( ram.lvbase + phdr[i].p_paddr, s ) ){
			printm("ELF: program segment not in RAM (%08X %08X)\n",
			       phdr[i].p_paddr, s);
			continue;
		}

		fs->lseek( fd, phdr[i].p_offset, SEEK_SET );
		addr = ram.lvbase + phdr[i].p_paddr;
		if( fs->read( fd, addr, s) != s ) {
			printm("read failed\n");
			exit(1);
		}
		flush_icache_range( addr, addr+s );
	}
	mregs->nip = ehdr.e_entry;
	mregs->msr = 0;
	mregs->spr[ S_SDR1 ] = ram.size - 65536;
	mregs->gpr[1] = ram.size - 65536 - 32;
	free( phdr );
}

static void
elf_cleanup( void )
{
}
