/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.zip.ZipFile;

public class URLHandler
implements URLStreamHandlerFactory {
    private URL sty = null;
    private URL src = null;

    public URLHandler() {
    }

    public URLHandler(File file, File file2) throws IOException {
        if (file == null) {
            throw new IOException("Null Sources");
        }
        if (file2 == null) {
            throw new IOException("Null Style");
        }
        if (file2.isDirectory()) {
            this.sty = file2.getCanonicalFile().toURL();
        } else if (file2.exists()) {
            new ZipFile(file2).close();
            this.sty = new URL("jar:" + file2.getCanonicalFile().toURL() + "!/");
        } else {
            throw new IOException("Style File/Directory not found");
        }
        if (!file.isFile()) {
            throw new IOException("Sources File/Directory not found");
        }
        this.src = file.getCanonicalFile().toURL();
    }

    public URLStreamHandler createURLStreamHandler(String string) {
        if (string == null) {
            return null;
        }
        try {
            if (string.equalsIgnoreCase("sbk")) {
                return new StylebookStreamHandler(this.sty, this.src);
            }
            if (string.equalsIgnoreCase("res")) {
                return new ResourceStreamHandler();
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private class ResourceStreamHandler
    extends URLStreamHandler {
        private ResourceStreamHandler() {
        }

        public URLConnection openConnection(URL uRL) throws IOException {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader == null) {
                return null;
            }
            String string = uRL.getFile();
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) != '/') {
                    string = string.substring(n);
                    break;
                }
                ++n;
            }
            URL uRL2 = classLoader.getResource(string);
            if (uRL2 == null) {
                uRL2 = ClassLoader.getSystemResource(uRL.getFile());
            }
            if (uRL2 == null) {
                return null;
            }
            return uRL2.openConnection();
        }
    }

    private class StylebookStreamHandler
    extends URLStreamHandler {
        private URL style = null;
        private URL sources = null;

        private StylebookStreamHandler() {
        }

        private StylebookStreamHandler(URL uRL, URL uRL2) throws IOException {
            this();
            this.style = uRL;
            this.sources = uRL2;
        }

        public URLConnection openConnection(URL uRL) throws IOException {
            if (uRL == null) {
                return null;
            }
            String string = uRL.getFile();
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) != '/') {
                    string = string.substring(n);
                    break;
                }
                ++n;
            }
            if (string.startsWith("style/")) {
                if (string.length() == 6) {
                    return this.style.openConnection();
                }
                return new URL(this.style, string.substring(6)).openConnection();
            }
            if (string.startsWith("sources/")) {
                if (string.length() == 8) {
                    return this.sources.openConnection();
                }
                return new URL(this.sources, string.substring(8)).openConnection();
            }
            throw new IOException("Invalid StyleBook URL \"" + uRL + "\"");
        }
    }
}

