/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class Touch
extends Task {
    private File file;
    private long millis = -1L;
    private String dateTime;
    private static Method setLastModified = null;
    private static Object lockReflection = new Object();
    static /* synthetic */ Class class$java$io$File;

    public void setFile(File file) {
        this.file = file;
    }

    public void setMillis(long l) {
        this.millis = l;
    }

    public void setDatetime(String string) {
        this.dateTime = string;
    }

    public void execute() throws BuildException {
        if (this.file.exists()) {
            if (Project.getJavaVersion() == "1.1") {
                this.log("Cannot change the modification time of " + this.file + " in JDK 1.1", 1);
                return;
            }
        }
        if (this.dateTime != null) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.US);
            try {
                this.setMillis(dateFormat.parse(this.dateTime).getTime());
            }
            catch (ParseException parseException) {
                throw new BuildException(parseException.getMessage(), parseException, this.location);
            }
        }
        if (this.millis >= 0L) {
            if (Project.getJavaVersion() == "1.1") {
                this.log(this.file + " will be created but its modification time cannot be set in JDK 1.1", 1);
            }
        }
        this.touch();
    }

    void touch() throws BuildException {
        Object object;
        if (!this.file.exists()) {
            this.log("Creating " + this.file, 2);
            try {
                object = new FileOutputStream(this.file);
                ((FileOutputStream)object).write(new byte[0]);
                ((FileOutputStream)object).close();
            }
            catch (IOException iOException) {
                throw new BuildException("Could not create " + this.file, iOException, this.location);
            }
        }
        if (Project.getJavaVersion() == "1.1") {
            return;
        }
        if (setLastModified == null) {
            object = lockReflection;
            synchronized (object) {
                if (setLastModified == null) {
                    try {
                        setLastModified = (class$java$io$File == null ? (class$java$io$File = Touch.class$("java.io.File")) : class$java$io$File).getMethod("setLastModified", Long.TYPE);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new BuildException("File.setlastModified not in JDK > 1.1?", noSuchMethodException, this.location);
                    }
                }
            }
        }
        object = new Long[]{this.millis < 0L ? new Long(System.currentTimeMillis()) : new Long(this.millis)};
        try {
            this.log("Setting modification time for " + this.file, 3);
            setLastModified.invoke((Object)this.file, (Object[])object);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new BuildException("Exception setting the modification time of " + this.file, throwable, this.location);
        }
        catch (Throwable throwable) {
            throw new BuildException("Exception setting the modification time of " + this.file, throwable, this.location);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

