/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.enhydra.instantdb.db.Table;

class ReadAheadBuffer
extends RandomAccessFile {
    private ByteArrayInputStream bytesIn;
    byte[] rowInputBuffer;
    private int firstRowCached;
    private int cachedRowCount;
    private int rowCacheSize;
    private Table table;
    private int recordLength;
    private boolean readAheadLocked;
    private int lastDecryptedRow;
    private byte[] encryptBuffer;
    private int cacheMisses;
    private int flushAfterCacheMisses;
    private byte[] singleRowBuffers;
    private int[] singleRows;
    private int lastSingleRowBuffer;
    private int singleRowCount;
    private ByteArrayInputStream singleIn;
    private DataInputStream singleDataIn;
    private DataInputStream oldDataIn;
    byte[] writeBuffer;
    int writeBufferSize;
    int writeBufferOffset;
    int writeBufferRow;

    ReadAheadBuffer(File file, String string, Table table, int n) throws IOException {
        super(file, string);
        this.table = table;
        if (this.table.tableType == 2) {
            return;
        }
        this.rowCacheSize = this.table.dbase.getIntegerProperty("rowCacheSize", "20");
        if (n > 0) {
            this.rowCacheSize = n;
        }
    }

    void addRowToWriteBuffer(byte[] byArray, int n) throws IOException {
        if (this.writeBufferOffset == 0) {
            this.writeBufferRow = n;
        }
        System.arraycopy(byArray, 0, this.writeBuffer, this.writeBufferOffset, this.recordLength);
        this.writeBufferOffset += this.recordLength;
        if (this.writeBufferOffset == this.writeBufferSize) {
            this.writeWriteBuffer(false);
        }
    }

    void createEncryptionBuffer() {
        this.encryptBuffer = new byte[this.recordLength];
    }

    void createWriteBuffer(int n) {
        this.writeBufferSize = n * this.recordLength;
        this.writeBuffer = new byte[this.writeBufferSize];
        this.writeBufferOffset = 0;
        this.writeBufferRow = 0;
        this.bytesIn = new ByteArrayInputStream(this.writeBuffer);
        this.table.dataIn = new DataInputStream(this.bytesIn);
    }

    void decryptRow(byte[] byArray, int n, int n2, int n3) throws IOException {
        if (this.lastDecryptedRow != n2) {
            int n4 = n * this.recordLength;
            System.arraycopy(byArray, n4, this.encryptBuffer, 0, this.recordLength);
            byte by = this.encryptBuffer[0];
            this.table.encryptor.Decrypt(this.table.tableName, this.encryptBuffer, n2, this.table.colOffsets);
            this.encryptBuffer[0] = by;
            this.bytesIn = new ByteArrayInputStream(this.encryptBuffer);
            this.table.dataIn = new DataInputStream(this.bytesIn);
            this.lastDecryptedRow = n2;
        }
        this.table.dataIn.reset();
        this.table.dataIn.skip(n3);
    }

    void dropColumnFromTable(int n, int n2, int n3, int n4, long l) throws IOException {
        int n5 = 0;
        int n6 = 1;
        while (n6 <= this.table.rowCount) {
            int n7 = this.readRow(n6, 0);
            System.arraycopy(this.rowInputBuffer, n7, this.rowInputBuffer, n5, n);
            System.arraycopy(this.rowInputBuffer, n7 + n2, this.rowInputBuffer, n5 + n, n4);
            n5 += n3;
            if (n6 == this.firstRowCached + this.cachedRowCount - 1) {
                this.seek(this.table.firstRowPosn - l + (long)((this.firstRowCached - 1) * n3));
                this.write(this.rowInputBuffer, 0, this.cachedRowCount * n3);
                n5 = 0;
            }
            this.freeReadAhead();
            ++n6;
        }
        this.recordLength = n3;
    }

    void freeReadAhead() {
        if (this.oldDataIn != null) {
            this.table.dataIn = this.oldDataIn;
            this.oldDataIn = null;
        }
        byte[] byArray = this.rowInputBuffer;
        synchronized (byArray) {
            this.readAheadLocked = false;
            this.rowInputBuffer.notify();
        }
    }

    boolean inCache(int n) {
        return n >= this.firstRowCached && n < this.firstRowCached + this.cachedRowCount;
    }

    boolean inSingleRowCache(int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.singleRowCount) {
            if (this.singleRows[n2] == n) {
                this.lastSingleRowBuffer = n2;
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    void invalidateCache(int n) {
        if (this.inCache(n)) {
            this.cachedRowCount = n - this.firstRowCached;
        } else if (this.inSingleRowCache(n)) {
            this.singleRows[this.lastSingleRowBuffer] = 0;
        }
    }

    void invalidateDecryptedRow(int n) {
        if (n == this.lastDecryptedRow) {
            this.lastDecryptedRow = 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int readRow(int n, int n2) throws IOException {
        int n3 = 0;
        if (this.writeBuffer != null) {
            this.bytesIn.reset();
            n3 = (n - this.writeBufferRow) * this.recordLength + n2;
            this.bytesIn.skip(n3);
            if (this.table.encryptor != null) {
                this.decryptRow(this.writeBuffer, n, this.writeBufferRow, n2);
            }
            return n2;
        }
        byte[] byArray = this.rowInputBuffer;
        synchronized (byArray) {
            while (true) {
                if (!this.readAheadLocked) {
                    this.readAheadLocked = true;
                    break;
                }
                try {
                    this.rowInputBuffer.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        if (!this.inCache(n)) {
            int n4;
            boolean bl = false;
            if (this.cachedRowCount == 0) {
                bl = true;
            }
            if (n == this.firstRowCached + this.cachedRowCount) {
                bl = true;
            }
            if (n == 1) {
                bl = true;
            }
            if (this.inCache(n4 = this.table.rowCount)) {
                bl = true;
            }
            if (this.cacheMisses > this.flushAfterCacheMisses) {
                this.cacheMisses = 0;
                bl = true;
            }
            if (bl) {
                this.cachedRowCount = n + this.rowCacheSize > this.table.rowCount + 1 ? this.table.rowCount - n + 1 : this.rowCacheSize;
            } else {
                ++this.cacheMisses;
                if (!this.inSingleRowCache(n)) {
                    if (++this.lastSingleRowBuffer == this.singleRowCount) {
                        this.lastSingleRowBuffer = 0;
                    }
                    this.seek(this.table.firstRowPosn + (long)((n - 1) * this.recordLength));
                    n3 = this.recordLength * this.lastSingleRowBuffer;
                    this.read(this.singleRowBuffers, n3, this.recordLength);
                    this.singleRows[this.lastSingleRowBuffer] = n;
                }
                n3 = this.recordLength * this.lastSingleRowBuffer;
                this.oldDataIn = this.table.dataIn;
                this.table.dataIn = this.singleDataIn;
                this.singleIn.reset();
                this.singleIn.skip(n3 + n2);
                if (this.table.encryptor != null) {
                    this.decryptRow(this.rowInputBuffer, this.lastSingleRowBuffer, n, n2);
                }
                return n2;
            }
            this.firstRowCached = n;
            this.seek(this.table.firstRowPosn + (long)((this.firstRowCached - 1) * this.recordLength));
            this.read(this.rowInputBuffer, 0, this.cachedRowCount * this.recordLength);
        }
        this.bytesIn.reset();
        n3 = (n - this.firstRowCached) * this.recordLength + n2;
        this.bytesIn.skip(n3);
        if (this.table.encryptor != null) {
            this.decryptRow(this.rowInputBuffer, n - this.firstRowCached, n, n2);
        }
        return n3;
    }

    void replaceRow(byte[] byArray, int n) {
        if (this.inCache(n)) {
            int n2 = (n - this.firstRowCached) * this.recordLength;
            System.arraycopy(byArray, 0, this.rowInputBuffer, n2, this.recordLength);
        } else if (this.inSingleRowCache(n)) {
            int n3 = this.lastSingleRowBuffer * this.recordLength;
            System.arraycopy(byArray, 0, this.singleRowBuffers, n3, this.recordLength);
        }
    }

    void setRecordLength(int n) {
        if (this.table.tableType == 2) {
            return;
        }
        this.recordLength = n;
        this.rowInputBuffer = new byte[this.rowCacheSize * n];
        this.bytesIn = new ByteArrayInputStream(this.rowInputBuffer);
        this.table.dataIn = new DataInputStream(this.bytesIn);
        this.singleRowCount = this.table.dbase.getIntegerProperty("singleRowCount", "8");
        this.flushAfterCacheMisses = this.table.dbase.getIntegerProperty("flushAfterCacheMisses", "128");
        this.singleRowBuffers = new byte[n * this.singleRowCount];
        this.singleIn = new ByteArrayInputStream(this.singleRowBuffers);
        this.singleDataIn = new DataInputStream(this.singleIn);
        this.singleRows = new int[this.singleRowCount];
    }

    void writeWriteBuffer(boolean bl) throws IOException {
        if (this.writeBufferOffset != 0) {
            long l = this.table.firstRowPosn + (long)((this.writeBufferRow - 1) * this.recordLength);
            this.seek(l);
            this.write(this.writeBuffer, 0, this.writeBufferOffset);
            this.writeBufferOffset = 0;
            this.table.writeEOF();
            if (this.table.fd != null) {
                this.table.fd.sync();
            }
        }
        if (bl) {
            this.writeBuffer = null;
            this.cachedRowCount = 0;
            this.bytesIn = new ByteArrayInputStream(this.rowInputBuffer);
            this.table.dataIn = new DataInputStream(this.bytesIn);
        }
    }
}

