/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Stack;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.CharReader;
import org.apache.xerces.readers.StringReader;
import org.apache.xerces.readers.UTF8Reader;
import org.apache.xerces.readers.XMLDeclRecognizer;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReaderFactory;
import org.apache.xerces.utils.ChunkyByteArray;
import org.apache.xerces.utils.StringPool;
import org.xml.sax.InputSource;

public class DefaultReaderFactory
implements XMLEntityReaderFactory {
    private static final boolean USE_CHAR_READER_FOR_UTF8 = false;
    private static final boolean USE_BYTE_READER_FOR_UTF8 = true;
    private boolean fSendCharDataAsCharArray = false;
    private boolean fAllowJavaEncodingName = false;
    private Stack fRecognizers = null;

    public void addRecognizer(XMLDeclRecognizer xMLDeclRecognizer) {
        if (this.fRecognizers == null) {
            this.fRecognizers = new Stack();
            XMLDeclRecognizer.registerDefaultRecognizers(this.fRecognizers);
        }
        this.fRecognizers.push(xMLDeclRecognizer);
    }

    public void setSendCharDataAsCharArray(boolean bl) {
        this.fSendCharDataAsCharArray = bl;
    }

    public void setAllowJavaEncodingName(boolean bl) {
        this.fAllowJavaEncodingName = bl;
    }

    public boolean getAllowJavaEncodingName() {
        return this.fAllowJavaEncodingName;
    }

    public XMLEntityHandler.EntityReader createReader(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, InputSource inputSource, String string, boolean bl, StringPool stringPool) throws Exception {
        Object object;
        if (inputSource.getCharacterStream() != null) {
            return this.createCharReader(xMLEntityHandler, xMLErrorReporter, this.fSendCharDataAsCharArray, inputSource.getCharacterStream(), stringPool);
        }
        if (inputSource.getEncoding() != null && inputSource.getByteStream() != null) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputSource.getByteStream(), inputSource.getEncoding());
            return this.createCharReader(xMLEntityHandler, xMLErrorReporter, this.fSendCharDataAsCharArray, inputStreamReader, stringPool);
        }
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream == null) {
            object = new URL(string);
            inputStream = ((URL)object).openStream();
        }
        object = new ChunkyByteArray(inputStream);
        if (this.fRecognizers == null) {
            this.fRecognizers = new Stack();
            XMLDeclRecognizer.registerDefaultRecognizers(this.fRecognizers);
        }
        int n = this.fRecognizers.size() - 1;
        while (n >= 0) {
            XMLDeclRecognizer xMLDeclRecognizer = (XMLDeclRecognizer)this.fRecognizers.elementAt(n);
            XMLEntityHandler.EntityReader entityReader = xMLDeclRecognizer.recognize(this, xMLEntityHandler, xMLErrorReporter, this.fSendCharDataAsCharArray, stringPool, (ChunkyByteArray)object, bl, this.fAllowJavaEncodingName);
            if (entityReader != null) {
                return entityReader;
            }
            --n;
        }
        return this.createUTF8Reader(xMLEntityHandler, xMLErrorReporter, this.fSendCharDataAsCharArray, (InputStream)object, stringPool);
    }

    public XMLEntityHandler.EntityReader createCharReader(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, Reader reader, StringPool stringPool) throws Exception {
        return new CharReader(xMLEntityHandler, xMLErrorReporter, bl, reader, stringPool);
    }

    public XMLEntityHandler.EntityReader createUTF8Reader(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, InputStream inputStream, StringPool stringPool) throws Exception {
        UTF8Reader uTF8Reader = new UTF8Reader(xMLEntityHandler, xMLErrorReporter, bl, inputStream, stringPool);
        return uTF8Reader;
    }

    public XMLEntityHandler.EntityReader createStringReader(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, int n, int n2, int n3, StringPool stringPool, boolean bl2) throws Exception {
        return StringReader.createStringReader(xMLEntityHandler, xMLErrorReporter, bl, n, n2, n3, stringPool, bl2);
    }
}

