/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/


package com.sap.dbtech.util.cache;

/**
 *
 */
public class DListElement
{
    private DListElement previousLink;
    private DListElement nextLink;
    private Object data;
    /**
     * creates a new DListElement
     */
    public
    DListElement (
        Object data)
    {
        this.data = data;
    }
    /**
     *
     */
    public Object
    getObject ()
    {
        return this.data;
    }
    /**
     *
     */
    public DListElement
    next ()
    {
        return this.nextLink;
    }
    /**
     *
     */
    public DListElement
    previous ()
    {
        return this.previousLink;
    }
    /**
     *
     */
    public boolean
    atStart ()
    {
        return this.previousLink == null;
    }
    /**
     *
     */
    public boolean
    atEnd ()
    {
        return this.nextLink == null;
    }
    /**
     *
     */
    public void
    remove ()
    {
        if (this.previousLink != null) {
            this.previousLink.nextLink = this.nextLink;
        }
        if (this.nextLink != null) {
            this.nextLink.previousLink = this.previousLink;
        }
        this.previousLink = null;
        this.nextLink = null;
    }
    /**
     *
     */
    public void
    prepend (
        DListElement newHead)
    {
        //@assert newHead != null
        //@assert newHead.nextLink == null
        newHead.nextLink = this;
        this.previousLink = newHead;
    }
    /**
     *
     */
    public void
    append (
        DListElement newTail)
    {
        //@assert newTail != null
        //@assert newTail.previousLink == null
        this.nextLink = newTail;
        newTail.previousLink = this;
    }
    /**
     *
     */
    public void
    insertAfter (
        DListElement newHead)
    {
        //@assert newHead != null
        DListElement newTail = newHead.nextLink;
        newHead.nextLink = this;
        this.previousLink = newHead;
        this.nextLink = newTail;
        if (newTail != null) {
            newTail.previousLink = this;
        }
    }
}

