/*
 * $Id: Chap0609.java,v 1.4 2003/06/25 07:36:33 blowagie Exp $
 * $Name:  $
 *
 * This code is free software. It may only be copied or modified
 * if you include the following copyright notice:
 *
 * --> Copyright 2001 by Bruno Lowagie & Paulo Soares <--
 *
 * This code is part of the 'iText Tutorial'.
 * You can find the complete tutorial at the following address:
 * http://www.lowagie.com/iText/tutorial/
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * itext-questions@lists.sourceforge.net
 */

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

import com.lowagie.text.*;
import com.lowagie.text.pdf.PdfWriter;

public class Chap0609 {
    
    public static void main(String[] args) {
        
        System.out.println("Chapter 6 example 9: bytes() / Raw Image");
        
        // step 1: creation of a document-object
        Document document = new Document();
        
        try {
            
            // step 2:
            // we create a writer that listens to the document
            // and directs a PDF-stream to a file
            
            PdfWriter.getInstance(document, new FileOutputStream("Chap0609.pdf"));
            
            // step 3: we open the document
            document.open();
            
            // step 4: we add content (example by Paulo Soares)
            
            // creation a jpeg passed as an array of bytes to the Image
            RandomAccessFile rf = new RandomAccessFile("myKids.jpg", "r");
            int size = (int)rf.length();
            byte imext[] = new byte[size];
            rf.readFully(imext);
            rf.close();
            Image img1 = Image.getInstance(imext);
            img1.setAbsolutePosition(50, 500);
            document.add(img1);
            
            // creation of an image of 100 x 100 pixels (x 3 bytes for the Red, Green and Blue value)
            byte data[] = new byte[100*100*3];
            for (int k = 0; k < 100; ++k) {
                for (int j = 0; j < 300; j += 3) {
                    data[k * 300 + j] = (byte)(255 * Math.sin(j * .5 * Math.PI / 300));
                    data[k * 300 + j + 1] = (byte)(256 - j * 256 / 300);
                    data[k * 300 + j + 2] = (byte)(255 * Math.cos(k * .5 * Math.PI / 100));
                }
            }
            Image img2 = Image.getInstance(100, 100, 3, 8, data);
            img2.setAbsolutePosition(200, 200);
            document.add(img2);
        }
        catch(DocumentException de) {
            System.err.println(de.getMessage());
        }
        catch(IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        
        // step 5: we close the document
        document.close();
    }
}
