/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jde.wizards.DefaultNameFactory;
import jde.wizards.MethodFactory;
import jde.wizards.NameFactory;
import jde.wizards.Signature;

public class DelegateFactory
extends MethodFactory {
    private Hashtable interfaces = new Hashtable();
    static DelegateFactory delegateFactory;

    public DelegateFactory() {
    }

    public DelegateFactory(NameFactory nameFactory) {
        super(nameFactory);
    }

    private final void sortByDeclaringClass(Signature signature) {
        String string = signature.getDeclaringClass().getName();
        if (this.interfaces.containsKey(string)) {
            Vector vector = (Vector)this.interfaces.get(string);
            if (!vector.contains(signature)) {
                vector.addElement(signature);
            }
        } else {
            Vector<Signature> vector = new Vector<Signature>();
            vector.addElement(signature);
            this.interfaces.put(string, vector);
        }
    }

    public void flush() {
        super.flush();
        this.interfaces.clear();
    }

    public void process(String string) throws ClassNotFoundException {
        this.process(string, true);
    }

    public void process(String string, boolean bl) throws ClassNotFoundException {
        if (null == this.namefactory) {
            this.namefactory = new DefaultNameFactory();
        }
        Class<?> clazz = Class.forName(string);
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            this.sortByDeclaringClass(new Signature(methodArray[n], this, bl, true));
            ++n;
        }
    }

    public static void makeDelegates(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (delegateFactory == null) {
            delegateFactory = new DelegateFactory();
        }
        delegateFactory.flush();
        delegateFactory.makeInterfaceInternal(string, string2, bl, bl2, bl3);
    }

    private void makeInterfaceInternal(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        try {
            this.process(string2, bl2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            MethodFactory.println("(error \"Error: could not find class named: " + string2 + ". " + "Note: name must be qualified.\")");
            return;
        }
        catch (Exception exception) {
            MethodFactory.println("(error \"Error: unknown type.\")");
            return;
        }
        this.dump(new PrintWriter(System.out, true), string, bl, bl2, bl3);
    }

    public static void getImportedClasses() {
        String string = "(list ";
        Enumeration enumeration = DelegateFactory.delegateFactory.imports.keys();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            string = string + "\"" + clazz.getName() + "\" ";
        }
        string = string + ")";
        MethodFactory.println(string);
    }

    public String getMethodSkeleton(Signature signature, boolean bl, boolean bl2, String string) {
        String string2 = "";
        string2 = string2 + "\n";
        if (bl) {
            string2 = string2 + signature.toJavaDoc() + "\n";
        }
        if (bl2) {
            string2 = string2 + signature + "\n";
            string2 = string2 + "{\n";
        } else {
            string2 = string2 + signature + " {\n";
        }
        Method method = signature.getMethod();
        Class<?> clazz = method.getReturnType();
        string2 = !clazz.getName().equals("void") ? string2 + "  return " + string + "." + method.getName() + "(" + signature.getParameterNames(method.getParameterTypes()) + ");\n" : string2 + "  " + string + "." + method.getName() + "(" + signature.getParameterNames(method.getParameterTypes()) + ");\n";
        string2 = string2 + "}\n";
        return string2;
    }

    public void dump(PrintWriter printWriter, String string, boolean bl, boolean bl2, boolean bl3) {
        StringBuffer stringBuffer = new StringBuffer("\"");
        Enumeration enumeration = this.interfaces.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Vector vector = (Vector)this.interfaces.get(string2);
            stringBuffer.append("// Code for delegation of ");
            stringBuffer.append(string2);
            stringBuffer.append(" methods to ");
            stringBuffer.append(string);
            stringBuffer.append("\n");
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Signature signature = (Signature)enumeration2.nextElement();
                stringBuffer.append(this.getMethodSkeleton(signature, bl, bl3, string));
            }
        }
        stringBuffer.append("\"");
        MethodFactory.println(stringBuffer.toString());
    }
}

