/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.PathSearchingVirtualMachine;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.Iterator;
import java.util.List;
import jde.debugger.Application;
import jde.debugger.ApplicationCommands;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.LispForm;
import jde.debugger.ObjectStore;
import jde.debugger.Protocol;
import jde.debugger.Rep;
import jde.debugger.ThreadCommands;

public class GeneralCommands
extends ApplicationCommands {
    public void doFinish(Integer n, List list) {
        this.app.shutdown();
        this.app.signalCommandResult(n);
    }

    public void doTraceClasses(Integer n, List list) throws JDEException {
        if (list.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        String string = list.remove(0).toString().toLowerCase();
        if (!string.equals("preparation") && !string.equals("unloading")) {
            throw new JDEException("Invalid type");
        }
        Long l = null;
        List list2 = Etc.getClassFiltersFromArgs(list);
        List list3 = Etc.getClassExFiltersFromArgs(list);
        EventRequestManager eventRequestManager = this.app.getVM().eventRequestManager();
        if (string.equals("preparation")) {
            Iterator iterator;
            ClassPrepareRequest classPrepareRequest = eventRequestManager.createClassPrepareRequest();
            classPrepareRequest.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(list));
            if (list2 != null) {
                iterator = list2.iterator();
                while (iterator.hasNext()) {
                    classPrepareRequest.addClassFilter(iterator.next().toString());
                }
            }
            if (list3 != null) {
                iterator = list3.iterator();
                while (iterator.hasNext()) {
                    classPrepareRequest.addClassExclusionFilter(iterator.next().toString());
                }
            }
            l = this.addIdentifiableRequest(classPrepareRequest);
        } else if (string.equals("unloading")) {
            Iterator iterator;
            ClassUnloadRequest classUnloadRequest = eventRequestManager.createClassUnloadRequest();
            classUnloadRequest.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(list));
            if (list2 != null) {
                iterator = list2.iterator();
                while (iterator.hasNext()) {
                    classUnloadRequest.addClassFilter(iterator.next().toString());
                }
            }
            if (list3 != null) {
                iterator = list3.iterator();
                while (iterator.hasNext()) {
                    classUnloadRequest.addClassExclusionFilter(iterator.next().toString());
                }
            }
            l = this.addIdentifiableRequest(classUnloadRequest);
        }
        this.app.signalCommandResult(n, l);
    }

    public void doCancelTraceClasses(Integer n, List list) throws JDEException {
        if (list.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        this.deleteIdentifiableRequest(Etc.safeGetLong(list.remove(0), "request ID"));
        this.app.signalCommandResult(n);
    }

    public void doTraceMethods(Integer n, List list) throws JDEException {
        if (list.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        String string = list.remove(0).toString().toLowerCase();
        if (!string.equals("entry") && !string.equals("exit")) {
            throw new JDEException("Invalid type");
        }
        Object object = Etc.getThreadFromArgs(list);
        ObjectReference objectReference = null;
        if (object == null) {
            objectReference = null;
        } else if (object instanceof Long) {
            objectReference = this.store.get(object);
            if (objectReference == null) {
                throw new JDEException("No such thread exists");
            }
            if (!(objectReference instanceof ThreadReference)) {
                throw new JDEException("No such thread exists (anymore?)");
            }
        } else if (object instanceof String) {
            objectReference = ThreadCommands.getThread(this.app.getVM(), object.toString());
        }
        List list2 = Etc.getClassFiltersFromArgs(list);
        List list3 = Etc.getClassExFiltersFromArgs(list);
        Long l = null;
        EventRequestManager eventRequestManager = this.app.getVM().eventRequestManager();
        if (string.equals("entry")) {
            Iterator iterator;
            MethodEntryRequest methodEntryRequest = eventRequestManager.createMethodEntryRequest();
            if (objectReference != null) {
                methodEntryRequest.addThreadFilter((ThreadReference)objectReference);
            }
            methodEntryRequest.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(list));
            if (list2 != null) {
                iterator = list2.iterator();
                while (iterator.hasNext()) {
                    methodEntryRequest.addClassFilter(iterator.next().toString());
                }
            }
            if (list3 != null) {
                iterator = list3.iterator();
                while (iterator.hasNext()) {
                    methodEntryRequest.addClassExclusionFilter(iterator.next().toString());
                }
            }
            l = this.addIdentifiableRequest(methodEntryRequest);
        } else if (string.equals("exit")) {
            Iterator iterator;
            MethodExitRequest methodExitRequest = eventRequestManager.createMethodExitRequest();
            if (objectReference != null) {
                methodExitRequest.addThreadFilter((ThreadReference)objectReference);
            }
            methodExitRequest.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(list));
            if (list2 != null) {
                iterator = list2.iterator();
                while (iterator.hasNext()) {
                    methodExitRequest.addClassFilter(iterator.next().toString());
                }
            }
            if (list3 != null) {
                iterator = list3.iterator();
                while (iterator.hasNext()) {
                    methodExitRequest.addClassExclusionFilter(iterator.next().toString());
                }
            }
            l = this.addIdentifiableRequest(methodExitRequest);
        }
        this.app.signalCommandResult(n, l);
    }

    public void doCancelTraceMethods(Integer n, List list) throws JDEException {
        if (list.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        this.deleteIdentifiableRequest(Etc.safeGetLong(list.remove(0), "request ID"));
        this.app.signalCommandResult(n);
    }

    public void doGetObject(Integer n, List list) throws JDEException {
        if (list.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        Long l = Etc.safeGetLong(list.remove(0), "object ID");
        ObjectReference objectReference = this.store.get(l);
        if (objectReference == null) {
            throw new JDEException("No such object exists");
        }
        this.app.signalCommandResult(n, Rep.getObjectRep(objectReference, this.store, true));
    }

    public void doGetLoadedClasses(Integer n, List list) throws JDEException {
        String string = "(list";
        Iterator<ReferenceType> iterator = this.app.getVM().allClasses().iterator();
        while (iterator.hasNext()) {
            string = string + " \"" + iterator.next().name() + "\"";
        }
        string = string + ")";
        this.app.signalCommandResult(n, new LispForm(string));
    }

    public void doGetPathInformation(Integer n, List list) throws JDEException {
        if (!(this.app.getVM() instanceof PathSearchingVirtualMachine)) {
            throw new JDEException("VM doesn't search paths");
        }
        PathSearchingVirtualMachine pathSearchingVirtualMachine = (PathSearchingVirtualMachine)this.app.getVM();
        String string = "(list";
        Iterator<String> iterator = pathSearchingVirtualMachine.bootClassPath().iterator();
        while (iterator.hasNext()) {
            string = string + " \"" + iterator.next() + "\"";
        }
        string = string + ")";
        string = string.replace('\\', '/');
        String string2 = "(list";
        iterator = pathSearchingVirtualMachine.classPath().iterator();
        while (iterator.hasNext()) {
            string2 = string2 + " \"" + iterator.next() + "\"";
        }
        string2 = string2 + ")";
        string2 = string2.replace('\\', '/');
        this.app.signalCommandResult(n, new LispForm("\"" + pathSearchingVirtualMachine.baseDirectory().replace('\\', '/') + "\"" + Protocol.BR + string + Protocol.BR + string2));
    }

    public GeneralCommands(Application application, ObjectStore objectStore) {
        super(application, objectStore);
    }
}

