package org.biojava.utils.bytecode;

/**
 * Instructions (like nop, dadd, etc.) which take no operands.
 *
 * @author Thomas Down
 * @author Matthew Pocock
 */

class NoOperandsInstruction implements Instruction {
  private final byte opcode;
  private final int delta;
  
  public NoOperandsInstruction(byte b, int delta) {
    this.opcode = b;
    this.delta = delta;
  }
  
  public void writeCode(CodeContext ctx) throws CodeException {
    ctx.writeByte(opcode);
  }
  
  public int stackDepth() {
    return Math.max(delta, 0);
  }
  
  public int stackDelta() {
    return delta;
  }
}
