package org.biojava.utils.bytecode;

/**
 * Instructions which jump to a label.
 *
 * @author Thomas Down
 * @author Matthew Pocock
 */

class LabelInstruction implements Instruction {
  private final Label l;
  private final byte opcode;
  private final int delta;
  
  LabelInstruction(byte op, Label l, int delta) {
    if(l == null) {
      throw new NullPointerException("Label can not be null");
    }
    
    this.opcode = op;
    this.l = l;
    this.delta = delta;
  }
  
  public void writeCode(CodeContext ctx) throws CodeException {
    ctx.writeByte(opcode);
    ctx.writeLabel(l);
  }
  
  public int stackDepth() {
    return 0;
  }
  
  public int stackDelta() {
    return delta;
  }
}
