
/**************************************************************************
 *                                                                        *
 *  BTools - Miscellaneous Java utility classes                           *
 *                                                                        *
 *  Copyright (c) 1998-2001, Ben Burton                                   *
 *  For further details contact Ben Burton (benb@acm.org).                *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,        *
 *  MA 02111-1307, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

package org.gjt.btools.gui.lookandfeel;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import org.gjt.btools.gui.*;
import org.gjt.btools.gui.dialog.MessageBox;

/**
 * Produces a dialog through which the user can select a swing look and
 * feel.  In general you should not need to create a new dialog object
 * yourself; the static member function chooseLookAndFeel() will do all
 * the work for you.
 * <p>
 * The dialog will automatically fill itself with a list of available 
 * look and feels.
 *
 * @see #chooseLookAndFeel
 */
public class LookAndFeelChooser extends JDialog implements ActionListener {
    /**
     * Look and feel that has been selected by the user.
     * @serial
     */
    private LookAndFeelItem chosen = null;

    /**
     * Combo box containing all available look and feels.
     * @serial
     */
    private JComboBox choices;

    /**
     * OK button.
     * @serial
     */
    private JButton ok;

    /**
     * Cancel button.
     * @serial
     */
    private JButton cancel;

    /**
     * Create a new dialog with the given frame as parent.
     *
     * @param parent the parent window for the new dialog.
     * @param title the title to give the new dialog.
     */
    public LookAndFeelChooser(Frame parent, String title) {
        super(parent, title, true);
        init();
        pack();
    }

    /**
     * Create a new dialog with the given dialog as parent.
     *
     * @param parent the parent window for the new dialog.
     * @param title the title to give the new dialog.
     */
    public LookAndFeelChooser(Dialog parent, String title) {
        super(parent, title, true);
        init();
        pack();
    }

    /**
     * Create interface components.
     */
    private void init() {
        // Initialise panels and layout managers.
        getContentPane().setLayout(new BorderLayout());

        // Create and add the list of available look-and-feels.
        // Attempt to select the current look and feel in the combo box.
        try {
            LookAndFeelItem[] all = LookAndFeelItem.getInstalledLookAndFeels();

            // Find the current look and feel so we can select it later.
            String currentLFName = UIManager.getLookAndFeel().getName();
            LookAndFeelItem currentLFItem = null;
            for (int i=0; i<all.length; i++) {
                if (all[i].toString().equals(currentLFName)) {
                    currentLFItem = all[i];
                    break;
                }
            }
            
            // Build the actual combo box and its containing pane.
            JPanel choicePane = new JPanel();
            choicePane.setLayout(new BorderLayout());
            choicePane.setBorder(new EmptyBorder(10,10,10,10));
            choices = new JComboBox(all);
            if (currentLFItem != null)
                choices.setSelectedItem(currentLFItem);
            choicePane.add(new JLabel("Select a look and feel:"),
                BorderLayout.NORTH);
            choicePane.add(choices, BorderLayout.CENTER);
            getContentPane().add(choicePane, BorderLayout.CENTER);
        } catch (Exception e) {
            e.printStackTrace();
        }

        // Create and add the button panel.
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout());
        ok = new JButton("OK");
        cancel = new JButton("Cancel");
        buttonPane.add(ok);
        buttonPane.add(cancel);
        getContentPane().add(buttonPane, BorderLayout.SOUTH);

        // Set action listeners.
        ok.addActionListener(this);
        cancel.addActionListener(this);
        getRootPane().setDefaultButton(ok);
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);

        // Centre on the screen.
        Positioner.centerOnScreen(this);
    }

    /**
     * Called when a button has been pressed.
     *
     * @param e details of the button pressing event.
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == ok) {
            chosen = (LookAndFeelItem)choices.getSelectedItem();
            if (chosen == null) {
                MessageBox.fgNote(this, "No look and feel has been selected.");
                return;
            }
        }
        dispose();
    }

    /**
     * Return the look and feel that has been selected by the user.
     * This will return information only if the dialog has been closed using
     * the <i>OK</i> button; otherwise <tt>null</tt> will be returned.
     * 
     * @return the look and feel selected by the user if the dialog was
     * closed using the <i>OK</i> button, or <tt>null</tt> otherwise.
     */
    public LookAndFeelItem getSelectedItem() {
        return chosen;
    }

    /**
     * Create and run a new dialog with which to select a look and feel,
     * and return the user's selection.
     *
     * @param parent the parent window for the new dialog.
     * @return the look and feel selected by the user if the dialog was
     * closing using the <i>OK</i> button, or <tt>null</tt> otherwise.
     */ 
    public static LookAndFeelItem chooseLookAndFeel(Frame parent) {
        LookAndFeelChooser dlg = new LookAndFeelChooser(parent,
            "Look and Feel");
        dlg.show();
        return dlg.getSelectedItem();
    }

    /**
     * Create and run a new dialog with which to select a look and feel,
     * and return the user's selection.
     *
     * @param parent the parent window for the new dialog.
     * @return the look and feel selected by the user if the dialog was
     * closing using the <i>OK</i> button, or <tt>null</tt> otherwise.
     */ 
    public static LookAndFeelItem chooseLookAndFeel(Dialog parent) {
        LookAndFeelChooser dlg = new LookAndFeelChooser(parent,
            "Look and Feel");
        dlg.show();
        return dlg.getSelectedItem();
    }
}

