! 
! File:          sort_IntegerContainer_Impl.F90
! Symbol:        sort.IntegerContainer-v0.1
! Symbol Type:   class
! Babel Version: 0.10.2
! Description:   Server-side implementation for sort.IntegerContainer
! 
! WARNING: Automatically generated; only changes within splicers preserved
! 
! babel-version = 0.10.2
! 


! 
! Symbol "sort.IntegerContainer" (version 0.1)
! 
! Integer container.
! 


#include "sidl_ClassInfo_fAbbrev.h"
#include "sort_Comparator_fAbbrev.h"
#include "sidl_BaseInterface_fAbbrev.h"
#include "sort_Container_fAbbrev.h"
#include "sort_IntegerContainer_fAbbrev.h"
#include "sidl_BaseClass_fAbbrev.h"
! DO-NOT-DELETE splicer.begin(_miscellaneous_code_start)
#include "sort_Integer_fAbbrev.h"
#include "synch_RegOut_fAbbrev.h"
! DO-NOT-DELETE splicer.end(_miscellaneous_code_start)




! 
! Class constructor called when the class is created.
! 

recursive subroutine sort_IntegerContainer__ctor_mi(self)
  use sort_IntegerContainer
  use sort_IntegerContainer_impl
  ! DO-NOT-DELETE splicer.begin(sort.IntegerContainer._ctor.use)
  use sort_Integer_array
  ! DO-NOT-DELETE splicer.end(sort.IntegerContainer._ctor.use)
  implicit none
  type(sort_IntegerContainer_t) :: self ! in

! DO-NOT-DELETE splicer.begin(sort.IntegerContainer._ctor)
  type(sort_IntegerContainer_wrap) :: pd
  allocate(pd%d_private_data)
  call set_null(pd%d_private_data%d_array)
  call sort_IntegerContainer__set_data_m(self, pd)
! DO-NOT-DELETE splicer.end(sort.IntegerContainer._ctor)
end subroutine sort_IntegerContainer__ctor_mi


! 
! Class destructor called when the class is deleted.
! 

recursive subroutine sort_IntegerContainer__dtor_mi(self)
  use sort_IntegerContainer
  use sort_IntegerContainer_impl
  ! DO-NOT-DELETE splicer.begin(sort.IntegerContainer._dtor.use)
  use sort_Integer_array
  ! DO-NOT-DELETE splicer.end(sort.IntegerContainer._dtor.use)
  implicit none
  type(sort_IntegerContainer_t) :: self ! in

! DO-NOT-DELETE splicer.begin(sort.IntegerContainer._dtor)
  type(sort_IntegerContainer_wrap) :: pd
  call sort_IntegerContainer__get_data_m(self, pd)
  if (not_null(pd%d_private_data%d_array)) then
     call deleteRef(pd%d_private_data%d_array)
     call set_null(pd%d_private_data%d_array)
  endif
  deallocate(pd%d_private_data)
! DO-NOT-DELETE splicer.end(sort.IntegerContainer._dtor)
end subroutine sort_IntegerContainer__dtor_mi


! 
! Static class initializer called exactly once before any user-defined method is dispatched
! 

recursive subroutine sort_IntegerContainer__load_mi()
  use sort_IntegerContainer
  use sort_IntegerContainer_impl
  ! DO-NOT-DELETE splicer.begin(sort.IntegerContainer._load.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(sort.IntegerContainer._load.use)
  implicit none

! DO-NOT-DELETE splicer.begin(sort.IntegerContainer._load)
! Insert the implementation here...
! DO-NOT-DELETE splicer.end(sort.IntegerContainer._load)
end subroutine sort_IntegerContainer__load_mi


! 
! This sets the container length and pseudo-randomly orders the
! Integer elements contained.
! 

recursive subroutine IntegerC_setLengthj8msmv4gje_mi(self, len)
  use sort_IntegerContainer
  use sort_IntegerContainer_impl
  ! DO-NOT-DELETE splicer.begin(sort.IntegerContainer.setLength.use)
  use sort_Integer
  use sort_Integer_array
  ! DO-NOT-DELETE splicer.end(sort.IntegerContainer.setLength.use)
  implicit none
  type(sort_IntegerContainer_t) :: self ! in
  integer (selected_int_kind(9)) :: len ! in

! DO-NOT-DELETE splicer.begin(sort.IntegerContainer.setLength)
  type(sort_Integer_t) :: intobj
  type(sort_IntegerContainer_wrap) :: dp
  integer(selected_int_kind(9)) :: i, tmp
  if (len .ge. 0) then
     call sort_IntegerContainer__get_data_m(self, dp)
     call deleteRef(dp%d_private_data%d_array)
     call create1d(len, dp%d_private_data%d_array)
     do i = 0, len - 1
        call new(intobj)
        call setValue(intobj, i+1)
        if (mod(i,2) .eq. 0) then
           tmp = i/2
        else
           tmp = len - 1 - i/2
        endif
        call set(dp%d_private_data%d_array, tmp, intobj)
        call deleteRef(intobj)
     enddo
   !     don't shuffle the list because no standard random number generator
     call sort_IntegerContainer__set_data_m(self, dp)
  endif
! DO-NOT-DELETE splicer.end(sort.IntegerContainer.setLength)
end subroutine IntegerC_setLengthj8msmv4gje_mi


! 
! Return the number of elements in the container.
! 

recursive subroutine IntegerC_getLength11uun9rvs6_mi(self, retval)
  use sort_IntegerContainer
  use sort_IntegerContainer_impl
  ! DO-NOT-DELETE splicer.begin(sort.IntegerContainer.getLength.use)
  use sort_Integer_array
  ! DO-NOT-DELETE splicer.end(sort.IntegerContainer.getLength.use)
  implicit none
  type(sort_IntegerContainer_t) :: self ! in
  integer (selected_int_kind(9)) :: retval ! out

! DO-NOT-DELETE splicer.begin(sort.IntegerContainer.getLength)
  type(sort_IntegerContainer_wrap) :: dp
  integer(selected_int_kind(9)) low, up
  integer(selected_int_kind(9)) zero
  data zero / 0 /
  call sort_IntegerContainer__get_data_m(self, dp)
  retval = 0
  if (not_null(dp%d_private_data%d_array)) then
     low = lower(dp%d_private_data%d_array, zero)
     up = upper(dp%d_private_data%d_array, zero)
     retval = 1 + up - low
  endif
! DO-NOT-DELETE splicer.end(sort.IntegerContainer.getLength)
end subroutine IntegerC_getLength11uun9rvs6_mi


! 
! Return -1 if element i is less than element j, 0 if element i
! is equal to element j, or otherwise 1.
! 

recursive subroutine IntegerCon_comparehztz37m8dj_mi(self, i, j, comp, retval)
  use sort_IntegerContainer
  use sort_Comparator
  use sort_IntegerContainer_impl
  ! DO-NOT-DELETE splicer.begin(sort.IntegerContainer.compare.use)
  use sort_Integer
  use sidl_BaseInterface
  use sort_Integer_array
  ! DO-NOT-DELETE splicer.end(sort.IntegerContainer.compare.use)
  implicit none
  type(sort_IntegerContainer_t) :: self ! in
  integer (selected_int_kind(9)) :: i ! in
  integer (selected_int_kind(9)) :: j ! in
  type(sort_Comparator_t) :: comp ! in
  integer (selected_int_kind(9)) :: retval ! out

! DO-NOT-DELETE splicer.begin(sort.IntegerContainer.compare)
  type(sort_IntegerContainer_wrap) :: dp
  type(sort_Integer_t) :: i1, i2
  type(sidl_BaseInterface_t) :: bi1, bi2
  call sort_IntegerContainer__get_data_m(self, dp)
  if (not_null(dp%d_private_data%d_array)) then
     call get(dp%d_private_data%d_array, i, i1)
     call get(dp%d_private_data%d_array, j, i2)
     call cast(i1, bi1)
     call cast(i2, bi2)
     call compare(comp, bi1, bi2, retval)
     call deleteRef(i1)
     call deleteRef(i2)
  endif
! DO-NOT-DELETE splicer.end(sort.IntegerContainer.compare)
end subroutine IntegerCon_comparehztz37m8dj_mi


! 
! Swap elements i and j.
! 

recursive subroutine sort_IntegerContainer_swap_mi(self, i, j)
  use sort_IntegerContainer
  use sort_IntegerContainer_impl
  ! DO-NOT-DELETE splicer.begin(sort.IntegerContainer.swap.use)
  use sort_Integer
  use sort_Integer_array
  use synch_RegOut
  ! DO-NOT-DELETE splicer.end(sort.IntegerContainer.swap.use)
  implicit none
  type(sort_IntegerContainer_t) :: self ! in
  integer (selected_int_kind(9)) :: i ! in
  integer (selected_int_kind(9)) :: j ! in

! DO-NOT-DELETE splicer.begin(sort.IntegerContainer.swap)
  type(sort_Integer_t) :: i1, i2
  type(sort_IntegerContainer_wrap) :: dp
  type(synch_RegOut_t) :: tracker
  integer(selected_int_kind(9)) len
  call sort_IntegerContainer__get_data_m(self, dp)
  if (not_null(dp%d_private_data%d_array)) then
     call getLength(self, len)
     if ((i .ge. 0) .and. (j .ge. 0) .and. &
          (i .lt. len) .and. (j .lt. len)) then
        call get(dp%d_private_data%d_array, i, i1)
        call get(dp%d_private_data%d_array, j, i2)
        call set(dp%d_private_data%d_array, i, i2)
        call set(dp%d_private_data%d_array, j, i1)
        call deleteRef(i1)
        call deleteRef(i2)
     else
        call getInstance(tracker)
        call writeComment(tracker, &
           'sort::IntegerContainer::swap index out of bounds')
        call forceFailure(tracker)
        call deleteRef(tracker)
     endif
  endif
! Insert the implementation here...
! DO-NOT-DELETE splicer.end(sort.IntegerContainer.swap)
end subroutine sort_IntegerContainer_swap_mi


! 
! Print elements s through e-1
! 

recursive subroutine sort_IntegerContainer_output_mi(self, s, e)
  use sort_IntegerContainer
  use sort_IntegerContainer_impl
  ! DO-NOT-DELETE splicer.begin(sort.IntegerContainer.output.use)
  use synch_RegOut
  ! DO-NOT-DELETE splicer.end(sort.IntegerContainer.output.use)
  implicit none
  type(sort_IntegerContainer_t) :: self ! in
  integer (selected_int_kind(9)) :: s ! in
  integer (selected_int_kind(9)) :: e ! in

! DO-NOT-DELETE splicer.begin(sort.IntegerContainer.output)
  type(synch_RegOut_t) :: tracker
  call getInstance(tracker)
  call writeComment(tracker, &
       'output list not implemented')
  call deleteRef(tracker)
! DO-NOT-DELETE splicer.end(sort.IntegerContainer.output)
end subroutine sort_IntegerContainer_output_mi


! DO-NOT-DELETE splicer.begin(_miscellaneous_code_end)
! Insert extra code here...
! DO-NOT-DELETE splicer.end(_miscellaneous_code_end)
