// 
// File:          objarg_EmployeeArray_Impl.hh
// Symbol:        objarg.EmployeeArray-v0.5
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for objarg.EmployeeArray
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 

#ifndef included_objarg_EmployeeArray_Impl_hh
#define included_objarg_EmployeeArray_Impl_hh

#ifndef included_sidl_ucxx_hh
#include "sidl_ucxx.hh"
#endif
#ifndef included_objarg_EmployeeArray_IOR_h
#include "objarg_EmployeeArray_IOR.h"
#endif
#ifndef included_objarg_EmployeeArray_hh
#include "objarg_EmployeeArray.hh"
#endif
#ifndef included_sidl_BaseClass_hh
#include "sidl_BaseClass.hh"
#endif


#line 30 "../../../../babel/regression/objarg/libUCxx/objarg_EmployeeArray_Impl.hh"
// DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._includes)
#ifndef included_objarg_Employee_hh
#include "objarg_Employee.hh"
#endif
#include <vector>
// DO-NOT-DELETE splicer.end(objarg.EmployeeArray._includes)
#line 37 "objarg_EmployeeArray_Impl.hh"

namespace objarg { 

  /**
   * Symbol "objarg.EmployeeArray" (version 0.5)
   * 
   * This class manages a collection of employees.
   */
  class EmployeeArray_impl : public virtual ::ucxx::objarg::EmployeeArray 
#line 45 "../../../../babel/regression/objarg/libUCxx/objarg_EmployeeArray_Impl.hh"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._inherits)
  // Put additional inheritance here...
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray._inherits)
#line 51 "objarg_EmployeeArray_Impl.hh"
  {

  // All data marked protected will be accessable by 
  // descendant Impl classes
  protected:

#line 54 "../../../../babel/regression/objarg/libUCxx/objarg_EmployeeArray_Impl.hh"
    // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._implementation)
    typedef std::vector<ucxx::objarg::Employee> d_array_t;
    d_array_t d_array;
    // DO-NOT-DELETE splicer.end(objarg.EmployeeArray._implementation)
#line 63 "objarg_EmployeeArray_Impl.hh"

  public:
    // default constructor, shouldn't be used (required)
    EmployeeArray_impl() : StubBase(0,true) { } 

      // sidl constructor (required)
      // Note: alternate Skel constructor doesn't call addref()
      // (fixes bug #275)
      EmployeeArray_impl( struct objarg_EmployeeArray__object * s ) : 
        StubBase(s,true) { _ctor(); }

      // user defined construction
      void _ctor();

      // virtual destructor (required)
      virtual ~EmployeeArray_impl() { _dtor(); }

      // user defined destruction
      void _dtor();

      // static class initializer
      static void _load();

    public:


      /**
       * Return the number of employees in the employee array.
       */
      int32_t
      getLength_impl() throw () 
      ;

      /**
       * Return the employee in position <code>index</code> where
       * <code>index</code> ranges from 1 to the length of the array.
       * If <code>index</code> is outside the range of the array (i.e.
       * less than or equal to zero or greater than the current number
       * of elements in the array), this method returns a NULL
       * employee object.
       */
      ::ucxx::objarg::Employee
      at_impl (
        /* in */int32_t index
      )
      throw () 
      ;


      /**
       * Add an employee onto the end of the array.  It is perfectly
       * legal to add the same employee multiple times.
       * <code>true</code> is returned when the append was successful;
       * otherwise, <code>false</code> is returned to indicate
       * failure.  This method will not add a NULL employee.
       */
      bool
      appendEmployee_impl (
        /* in */::ucxx::objarg::Employee e
      )
      throw () 
      ;


      /**
       * Find the first employee in the array that has a name matching
       * <code>name</code>.  If a match exists, the index is returned,
       * and the employee is returned in parameter <code>e</code>.
       * 
       * If no match exists, 0 is returned, and <code>e</code> is NULL.
       */
      int32_t
      findByName_impl (
        /* in */const ::std::string& name,
        /* out */::ucxx::objarg::Employee& e
      )
      throw () 
      ;


      /**
       * Determine the maximum salary in the array. If the maximum
       * salary in the array is greater than the current salary of
       * <code>e</code>, the salary of <code>e</code> will be 
       * increased to the maximum salary in the array.  If the
       * array is empty, no change will be made to <code>e</code>.
       * 
       * This method returns <code>true</code> iff the salary of
       * <code>e</code> is modified.
       */
      bool
      promoteToMaxSalary_impl (
        /* inout */::ucxx::objarg::Employee& e
      )
      throw () 
      ;

    };  // end class EmployeeArray_impl

  } // end namespace objarg

#line 159 "../../../../babel/regression/objarg/libUCxx/objarg_EmployeeArray_Impl.hh"
// DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._misc)
// Put miscellaneous things here...
// DO-NOT-DELETE splicer.end(objarg.EmployeeArray._misc)
#line 169 "objarg_EmployeeArray_Impl.hh"

  #endif
