/*
 * File:        exceptionclient.c
 * Copyright:   (c) 2001 The Regents of the University of California
 * Revision:    @(#) $Revision: 4434 $
 * Date:        $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
 * Description: Exception Test C client
 *
 */

#include <stdio.h>
#include "sidl_Exception.h"
#include "sidl_String.h"
#include "ExceptionTest_Fib.h"
#include "synch.h"

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif


static void declare_part(synch_RegOut tracker,
                         int * part_no )
{
  synch_RegOut_startPart(tracker, ++(*part_no));
}

static void end_part(synch_RegOut tracker, int part_no, 
                     enum synch_ResultType__enum result)
{
  synch_RegOut_endPart(tracker, part_no, result);
}

static void traceback(sidl_BaseInterface _ex)
{
  sidl_BaseException be = sidl_BaseException__cast(_ex);
  char* msg = NULL;
  if (be) {
    msg = sidl_BaseException_getNote(be);
    printf("%s\n", msg);
    sidl_String_free(msg);

    msg = sidl_BaseException_getTrace(be);
    printf("%s\n", msg);
    sidl_String_free(msg);
  }
}

#define CHECK(FUNC,COMMENT)                   \
  declare_part(tracker, &part_no);             \
  synch_RegOut_writeComment(tracker, COMMENT); \
  result = (FUNC) ? synch_ResultType_PASS : synch_ResultType_FAIL;            \
  end_part(tracker, part_no, result);

int runTest1(ExceptionTest_Fib f)
{
  int x;
  sidl_BaseInterface _ex = NULL;

  x = ExceptionTest_Fib_getFib(f, 10, 25, 200, 0, &_ex); SIDL_CHECK(_ex);
  return TRUE;

  EXIT:;
    traceback(_ex);
    SIDL_CLEAR(_ex);
    return FALSE;
}

int runTest2(ExceptionTest_Fib f)
{
  int x;
  sidl_BaseInterface _ex = NULL;

  x = ExceptionTest_Fib_getFib(f, -1, 10, 10, 0, &_ex);
  if (SIDL_CATCH(_ex, "ExceptionTest.NegativeValueException")) {
    traceback(_ex);
    SIDL_CLEAR(_ex);
  } else if (_ex == NULL) {
    return FALSE;
  }
  SIDL_CHECK(_ex);
  return TRUE;

  EXIT:;
    traceback(_ex);
    SIDL_CLEAR(_ex);
    return FALSE;
}

int runTest3(ExceptionTest_Fib f)
{
  int x;
  sidl_BaseInterface _ex = NULL;

  x = ExceptionTest_Fib_getFib(f, 10, 1, 100, 0, &_ex);
  if (SIDL_CATCH(_ex, "ExceptionTest.TooDeepException")) {
    traceback(_ex);
    SIDL_CLEAR(_ex);
  } else if (_ex == NULL) {
    return FALSE;
  }
  SIDL_CHECK(_ex);
  return TRUE;

  EXIT:;
    traceback(_ex);
    SIDL_CLEAR(_ex);
    return FALSE;
}

int runTest4(ExceptionTest_Fib f)
{
  int x;
  sidl_BaseInterface _ex = NULL;

  x = ExceptionTest_Fib_getFib(f, 10, 100, 1, 0, &_ex);
  if (SIDL_CATCH(_ex, "ExceptionTest.TooBigException")) {
    traceback(_ex);
    SIDL_CLEAR(_ex);
  } else if (_ex == NULL) {
    return FALSE;
  }
  SIDL_CHECK(_ex);
  return TRUE;

  EXIT:;
    traceback(_ex);
    SIDL_CLEAR(_ex);
    return FALSE;
}

int main(int argc, char**argv)
{ 
  enum synch_ResultType__enum result       = synch_ResultType_PASS; 
  int magicNumber  = 1;
  int part_no      = 0;

  ExceptionTest_Fib fib = ExceptionTest_Fib__create ();
  synch_RegOut tracker = synch_RegOut__create();

  (void) argc;
  (void) argv;
  synch_RegOut_setExpectations(tracker, 4);
  CHECK(runTest1(fib), "checking no exception thrown");
  CHECK(runTest2(fib), "checking ExceptionTest.NegativeValueException");
  CHECK(runTest3(fib), "checking ExceptionTest.TooDeepException");
  CHECK(runTest4(fib), "checking ExceptionTest.TooBigException");
  synch_RegOut_close(tracker);
  synch_RegOut_deleteRef(tracker);

  ExceptionTest_Fib_deleteRef (fib);
  return 0;
}
