!
! File:       argstest.F90
! Copyright:  (c) 2002 The Regents of the University of California
! Revision:   @(#) $Revision: 4434 $
! Date:       $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
! Description:Exercise the FORTRAN interface
!
!
#include "Args_Cfloat_fAbbrev.h"
#include "Args_Cdouble_fAbbrev.h"
#include "Args_Cint_fAbbrev.h"
#include "Args_Clong_fAbbrev.h"
#include "Args_Cdcomplex_fAbbrev.h"
#include "Args_Cfcomplex_fAbbrev.h"
#include "Args_Cbool_fAbbrev.h"
#include "Args_Cchar_fAbbrev.h"
#include "synch_RegOut_fAbbrev.h"
#include "synch_ResultType_fAbbrev.h"

subroutine starttest(number)
  use synch_RegOut
  implicit none
  integer (selected_int_kind(9)) :: number
  type(synch_RegOut_t) :: tracker
  call getInstance(tracker)
  call startPart(tracker, number)
  call deleteRef(tracker)
end subroutine starttest

subroutine reporttest(test, number, python)
  use synch_RegOut
  use synch_ResultType
  implicit none
  integer (kind=selected_int_kind(9)) :: number
  logical                             :: test, python
  type(synch_RegOut_t) :: tracker
  call getInstance(tracker)
  if (test) then
     call endPart(tracker, number, PASS)
  else
     if (python) then
        call endPart(tracker, number, XFAIL)
     else
        call endPart(tracker, number, FAIL)
     endif
  endif
  call deleteRef(tracker)
  number = number + 1
end subroutine reporttest

subroutine testbool(test)
  use Args_Cbool
  implicit none
  type(Args_Cbool_t) :: obj
  integer (selected_int_kind(9))  :: test
  logical                         :: out, inout, retval

  inout = .true.
  call new(obj)
  call starttest(test)
  call returnback(obj, retval)
  call reporttest(retval, test,  .false.)
  call starttest(test)
  call passin(obj, .true., retval)
  call reporttest(retval, test,  .false.)
  call starttest(test)
  call passout(obj, out, retval)
  call reporttest(retval .and. out, test,  .false.)
  call starttest(test)
  call passinout(obj, inout, retval)
  call reporttest(retval .and. .not. inout, test,  .false.)
  call starttest(test)
  call passeverywhere(obj, .true., out, inout, retval)
  call reporttest(retval .and. out .and. inout, test,  &
                  .false.)
  call deleteRef(obj)
end subroutine testbool

subroutine testint(test)
  use Args_Cint
  implicit none
  type(Args_Cint_t) :: obj
  integer (selected_int_kind(9))  :: test 
  logical                         :: bretval
  integer (selected_int_kind(9))  :: iretval, out, inout

  inout = 3
  call new(obj)
  call starttest(test)
  call returnback(obj, iretval)
  call reporttest(iretval .eq. 3, test,  .false.)
  call starttest(test)
  call passin(obj, 3, bretval)
  call reporttest(bretval, test,  .false.)
  call starttest(test)
  call passout(obj, out, bretval)
  call reporttest(bretval .and. (out .eq. 3), test,  .false.)
  call starttest(test)
  call passinout(obj, inout, bretval)
  call reporttest(bretval .and. (inout .eq. -3), test,  &
                  .false.)
  call starttest(test)
  call passeverywhere(obj, 3, out, inout, iretval)
  call reporttest((iretval .eq. 3) .and.  (out .eq. 3) .and. &
                  (inout .eq. 3), test,  .false.)
  call deleteRef(obj)
end subroutine testint

subroutine testchar(test)
  use Args_Cchar
  implicit none
  type (Args_Cchar_t) :: obj
  integer (selected_int_kind(9))  :: test
  logical                         :: bretval
  character (len=1)               :: cretval, out, inout

  inout = 'A'
  call new(obj)
  call starttest(test)
  call returnback(obj, cretval)
  call reporttest(cretval .eq. '3', test,  .false.)
  call starttest(test)
  call passin(obj, '3', bretval)
  call reporttest(bretval, test,  .false.)
  call starttest(test)
  call passout(obj, out, bretval)
  call reporttest(bretval .and. (out .eq. '3'), test,  &
                  .false.)
  call starttest(test)
  call passinout(obj, inout, bretval)
  call reporttest(bretval .and. (inout .eq. 'a'), test,  &
                  .false.)
  call starttest(test)
  call passeverywhere(obj, '3', out, inout, cretval)
  call reporttest((cretval .eq. '3') .and.  (out .eq. '3') .and. &
                  (inout .eq. 'A'), test,  .false.)
  call deleteRef(obj)
end subroutine testchar

subroutine testlong(test)
  use Args_Clong
  implicit none
  type(Args_Clong_t) :: obj
  integer (selected_int_kind(9))  :: test
  logical                         :: bretval
  integer (selected_int_kind(18)) :: out, inout, iretval, inval

  inout = 3
  call new(obj)
  call starttest(test)
  call returnback(obj, iretval)
  call reporttest(iretval .eq. 3, test,  .false.)
  call starttest(test)
  inval = 3
  call passin(obj, inval, bretval)
  call reporttest(bretval, test,  .false.)
  call starttest(test)
  call passout(obj, out, bretval)
  call reporttest(bretval .and. (out .eq. 3), test,  .false.)
  call starttest(test)
  call passinout(obj, inout, bretval)
  call reporttest(bretval .and. (inout .eq. -3), test,  &
                  .false.)
  call starttest(test)
  inval = 3
  call passeverywhere(obj, inval, out, inout, iretval)
  call reporttest((iretval .eq. 3) .and.  (out .eq. 3) .and. &
                  (inout .eq. 3), test,  .false.)
  call deleteRef(obj)
end subroutine testlong

subroutine testfloat(test,  python)
  use Args_Cfloat
  implicit none
  type(Args_Cfloat_t) :: obj
  integer (selected_int_kind(9))  :: test
  logical                         :: bretval, python
  real (selected_real_kind(6,37)) :: out, inout, fretval

  inout = 3.1
  call new(obj)
  call starttest(test)
  call returnback(obj, fretval)
  call reporttest(fretval .eq. 3.1, test,  .false.)
  call starttest(test)
  call passin(obj, 3.1, bretval)
  call reporttest(bretval, test,  python)
  call starttest(test)
  call passout(obj, out, bretval)
  call reporttest(bretval .and. (out .eq. 3.1), test,  &
                  .false.)
  call starttest(test)
  call passinout(obj, inout, bretval)
  call reporttest(bretval .and. (inout .eq. -3.1), test,  &
                  .false.)
  call starttest(test)
  call passeverywhere(obj, 3.1, out, inout, fretval)
  call reporttest((fretval .eq. 3.1) .and.  (out .eq. 3.1) .and. &
                  (inout .eq. 3.1), test,  python)
  call deleteRef(obj)
end subroutine testfloat

subroutine testdouble(test)
  use Args_Cdouble
  implicit none
  type(Args_Cdouble_t) :: obj
  integer (selected_int_kind(9))    :: test
  logical                           :: bretval
  real (selected_real_kind(15,307)) :: out, inout, dretval

  inout = 3.14d0
  call new(obj)
  call starttest(test)
  call returnback(obj, dretval)
  call reporttest(dretval .eq. 3.14d0, test,  .false.)
  call starttest(test)
  call passin(obj, 3.14d0, bretval)
  call reporttest(bretval, test,  .false.)
  call starttest(test)
  call passout(obj, out, bretval)
  call reporttest(bretval .and. (out .eq. 3.14d0), test,  &
                  .false.)
  call starttest(test)
  call passinout(obj, inout, bretval)
  call reporttest(bretval .and. (inout .eq. -3.14d0), test,  &
                  .false.)
  call starttest(test)
  call passeverywhere(obj, 3.14d0, out, inout, dretval)
  call reporttest((dretval .eq. 3.14d0) .and.  (out .eq. 3.14d0) .and. &
                  (inout .eq. 3.14d0), test,  .false.)
  call deleteRef(obj)
end subroutine testdouble

subroutine testfcomplex(test,  python)
  use Args_Cfcomplex
  implicit none
  type(Args_Cfcomplex_t) :: obj
  integer (selected_int_kind(9))     :: test
  logical                            :: bretval, python
  complex (selected_real_kind(6,37)) :: in, out, inout, cretval

  in = (3.1,3.1)
  inout = (3.1, 3.1)
  call new(obj)
  call starttest(test)
  call returnback(obj, cretval)
  call reporttest(cretval .eq. (3.1,3.1), test,  .false.)
  call starttest(test)
  call passin(obj, in, bretval)
  call reporttest(bretval, test,  python)
  call starttest(test)
  call passout(obj, out, bretval)
  call reporttest(bretval .and. (out .eq. (3.1,3.1)), test,  &
                  .false.)
  call starttest(test)
  call passinout(obj, inout, bretval)
  call reporttest(bretval .and. (inout .eq. (3.1,-3.1)), test, &
                  .false.)
  call starttest(test)
  call passeverywhere(obj, in, out, inout, cretval)
  call reporttest((cretval .eq. (3.1,3.1)) .and.  (out .eq. (3.1,3.1)) .and. &
                  (inout .eq. (3.1,3.1)), test,  python)
  call deleteRef(obj)
end subroutine testfcomplex

subroutine testdcomplex(test)
  use Args_Cdcomplex
  implicit none
  type(Args_Cdcomplex_t) :: obj
  integer (selected_int_kind(9))       :: test
  logical                              :: bretval
  complex (selected_real_kind(15,307)) :: in, out, inout, cretval

  in = (3.14d0,3.14d0)
  inout = (3.14d0, 3.14d0)
  call new(obj)
  call starttest(test)
  call returnback(obj, cretval)
  call reporttest(cretval .eq. (3.14d0,3.14d0), test,  &
                  .false.)
  call starttest(test)
  call passin(obj, in, bretval)
  call reporttest(bretval, test,  .false.)
  call starttest(test)
  call passout(obj, out, bretval)
  call reporttest(bretval .and. (out .eq. (3.14d0,3.14d0)), test, &
                   .false.)
  call starttest(test)
  call passinout(obj, inout, bretval)
  call reporttest(bretval .and. (inout .eq. (3.14d0,-3.14d0)), test, &
                  .false.)
  call starttest(test)
  call passeverywhere(obj, in, out, inout, cretval)
  call reporttest((cretval .eq. (3.14d0,3.14d0)) .and.  &
                  (out .eq. (3.14d0,3.14d0)) .and. &
                  (inout .eq. (3.14d0,3.14d0)), test,   &
                  .false.)
  call deleteRef(obj)
end subroutine testdcomplex


program argstest
  use synch_RegOut
  integer (selected_int_kind(9)) :: test
  character (len=80)             :: language
  type(synch_RegOut_t) :: tracker
  language = ' '
  if (IArgc() .eq. 1) then
     call GetArg(1, language)
  endif
  call getInstance(tracker)
  test = 1
  call setExpectations(tracker, 40)
  call writeComment(tracker, 'Boolean tests')
  call testbool(test)
  call writeComment(tracker, 'Character tests')
  call testchar(test)
  call writeComment(tracker, 'Integer tests')
  call testint(test)
  call writeComment(tracker, 'Long tests')
  call testlong(test)
  call writeComment(tracker, 'Float tests')
  call testfloat(test,  language .eq. 'Python')
  call writeComment(tracker, 'Double tests')
  call testdouble(test)
  call writeComment(tracker, 'Fcomplex tests')
  call testfcomplex(test,  language .eq. 'Python')
  call writeComment(tracker, 'Dcomplex tests')
  call testDcomplex(test)
  call close(tracker)
  call deleteRef(tracker)
end program argstest
