/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.url;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Provider;
import java.security.Security;

public class URLUtilities {
    private static final String EOL = "\n";
    private static boolean s_enabled_https = false;

    public static String readURL(String url) throws MalformedURLException, IOException {
        InputStream is = new URL(url).openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuffer buffer = new StringBuffer();
        String line = null;
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
            buffer.append(EOL);
        }
        is.close();
        return buffer.toString();
    }

    public static String expandURL(String url) {
        if (url != null && url.length() > 0) {
            try {
                URL u = new URL(url);
            }
            catch (MalformedURLException ex1) {
                File file = new File(url);
                try {
                    URL u = file.toURL();
                    url = u.toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return url;
    }

    public static void enableHTTPS() {
        if (!s_enabled_https) {
            try {
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                Class<?> f = Class.forName("com.sun.net.ssl.internal.ssl.Provider");
                if (f != null && Security.getProvider("SunJSSE") == null) {
                    Security.addProvider((Provider)f.newInstance());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            s_enabled_https = true;
        }
    }
}

